/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.orechid;

import com.google.common.collect.ListMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import vazkii.botania.api.recipe.IOrechidRecipe;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.common.lib.ResourceLocationHelper;

public abstract class OrechidRecipeCategoryBase
implements IRecipeCategory<IOrechidRecipe> {
    private final IDrawableStatic background;
    private final Component localizedName;
    private final IDrawableStatic overlay;
    private final IDrawable icon;
    private final ItemStack iconStack;

    public OrechidRecipeCategoryBase(IGuiHelper guiHelper, ItemStack iconStack, Component localizedName) {
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 44);
        this.background = guiHelper.createBlankDrawable(96, 44);
        this.localizedName = localizedName;
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)iconStack);
        this.iconStack = iconStack;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public static float getTotalOreWeight(List<? extends IOrechidRecipe> weights, int myWeight) {
        return weights.stream().map(IOrechidRecipe::getWeight).reduce(Integer::sum).orElse(myWeight * 64 * 64).intValue();
    }

    protected abstract RecipeType<? extends IOrechidRecipe> recipeType();

    protected List<? extends IOrechidRecipe> getOreWeights(Block input) {
        ListMultimap<Block, ? extends IOrechidRecipe> multimap = OrechidManager.getFor(Minecraft.m_91087_().f_91073_.m_7465_(), this.recipeType());
        return multimap.get((Object)input);
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull IOrechidRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 9, 12).addItemStack(new ItemStack((ItemLike)recipe.getInput(), 64));
        builder.addSlot(RecipeIngredientRole.CATALYST, 39, 12).addItemStack(this.iconStack);
        int myWeight = recipe.getWeight();
        int amount = Math.max(1, Math.round((float)myWeight * 64.0f / OrechidRecipeCategoryBase.getTotalOreWeight(this.getOreWeights(recipe.getInput()), myWeight)));
        List<ItemStack> stackList = recipe.getOutput().getDisplayedStacks();
        stackList.forEach(s -> s.m_41764_(amount));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 68, 12).addItemStacks(stackList)).addTooltipCallback((view, tooltip) -> tooltip.addAll(recipe.getOutput().descriptionTooltip()));
    }

    public void draw(@Nonnull IOrechidRecipe recipe, @Nonnull IRecipeSlotsView view, @Nonnull PoseStack ms, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(ms, 17, 0);
        RenderSystem.m_69461_();
    }
}

