/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.ICompositableLens;

public class CompositeLensRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<CompositeLensRecipe> SERIALIZER = new SimpleRecipeSerializer(CompositeLensRecipe::new);

    public CompositeLensRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundLens = false;
        boolean foundSecondLens = false;
        boolean foundSlimeball = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ICompositableLens && !foundSecondLens) {
                if (foundLens) {
                    foundSecondLens = true;
                    continue;
                }
                foundLens = true;
                continue;
            }
            if (stack.m_150930_(Items.f_42518_)) {
                foundSlimeball = true;
                continue;
            }
            return false;
        }
        return foundSecondLens && foundSlimeball;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        Item stack;
        ItemStack lens = ItemStack.f_41583_;
        ItemStack secondLens = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ICompositableLens)) continue;
            if (lens.m_41619_()) {
                lens = stack;
                continue;
            }
            secondLens = stack;
        }
        stack = lens.m_41720_();
        if (stack instanceof ICompositableLens) {
            ICompositableLens lensItem = (ICompositableLens)stack;
            if (secondLens.m_41619_() || !lensItem.canCombineLenses(lens, secondLens) || !lensItem.getCompositeLens(lens).m_41619_() || !lensItem.getCompositeLens(secondLens).m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack lensCopy = lens.m_41777_();
            ItemStack secondCopy = secondLens.m_41777_();
            lensCopy.m_41764_(1);
            secondCopy.m_41764_(1);
            lensItem.setCompositeLens(lensCopy, secondCopy);
            return lensCopy;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 3;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

