/*
 * Decompiled with CFR 0.152.
 */
package cn.leomc.curiosquarkobp;

import cn.leomc.curiosquarkobp.BackpackCurio;
import cn.leomc.curiosquarkobp.BackpackCurioRenderer;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;
import vazkii.quark.addons.oddities.inventory.BackpackMenu;
import vazkii.quark.addons.oddities.module.BackpackModule;

@Mod(value="curiosquarkobp")
public class CuriosQuarkOdditiesBackpack {
    public static final String MODID = "curiosquarkobp";
    public static final Logger LOGGER = LogManager.getLogger();

    public CuriosQuarkOdditiesBackpack() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::enqueueIMC);
        eventBus.addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        CuriosRendererRegistry.register((Item)BackpackModule.backpack, BackpackCurioRenderer::new);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    @Mod.EventBusSubscriber(modid="curiosquarkobp")
    public static class Events {
        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
            ItemStack stack = (ItemStack)event.getObject();
            if (stack.m_41720_() == BackpackModule.backpack) {
                final BackpackCurio curioBackpack = new BackpackCurio(stack);
                event.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                    final LazyOptional<ICurio> curio = LazyOptional.of(() -> curioBackpack);

                    @Nonnull
                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction side) {
                        return CuriosCapability.ITEM.orEmpty(capability, this.curio);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
            ServerPlayer player;
            LivingEntity livingEntity = event.getEntityLiving();
            if (!(livingEntity instanceof ServerPlayer) || (player = (ServerPlayer)livingEntity).m_21224_() || player.m_146910_() || event.getSlot() != EquipmentSlot.CHEST) {
                return;
            }
            if (player.f_36096_.getClass() == BackpackMenu.class) {
                if (event.getFrom().m_41720_() == BackpackModule.backpack && event.getTo().m_41720_() != BackpackModule.backpack) {
                    Optional result = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, BackpackModule.backpack);
                    if (result.isPresent()) {
                        ItemStack holding = player.f_36096_.m_142621_();
                        player.f_36096_.m_142503_(ItemStack.f_41583_);
                        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)((MenuProvider)((SlotResult)result.get()).stack().m_41720_()), (BlockPos)player.m_142538_());
                        player.f_36096_.m_142503_(holding);
                    }
                } else if (event.getTo().m_41720_() == BackpackModule.backpack && event.getFrom().m_41720_() != BackpackModule.backpack) {
                    ItemStack holding = player.f_36096_.m_142621_();
                    player.f_36096_.m_142503_(ItemStack.f_41583_);
                    NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)((MenuProvider)event.getTo().m_41720_()), (BlockPos)player.m_142538_());
                    player.f_36096_.m_142503_(holding);
                }
            }
        }
    }
}

