/*
 * Decompiled with CFR 0.152.
 */
package cn.leomc.curiosquarkobp.mixin;

import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import vazkii.quark.addons.oddities.module.BackpackModule;
import vazkii.quark.base.module.QuarkModule;

@Mixin(value={BackpackModule.class})
public abstract class BackpackModuleMixin
extends QuarkModule {
    @Inject(method={"isEntityWearingBackpack(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void isEntityWearingBackpack(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            boolean hasBackpack = CuriosApi.getCuriosHelper().findFirstCurio(livingEntity, BackpackModule.backpack).isPresent();
            if (hasBackpack) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"isEntityWearingBackpack(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void isEntityWearingBackpack(Entity entity, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Optional result = CuriosApi.getCuriosHelper().findFirstCurio(livingEntity, BackpackModule.backpack);
            if (result.isPresent() && ((SlotResult)result.get()).stack() == stack) {
                cir.setReturnValue((Object)true);
            }
        }
    }
}

