/*
 * Decompiled with CFR 0.152.
 */
package cn.leomc.curiosquarkobp.mixin;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import vazkii.quark.addons.oddities.entity.TotemOfHoldingEntity;
import vazkii.quark.addons.oddities.module.TotemOfHoldingModule;

@Mixin(value={TotemOfHoldingEntity.class})
public abstract class TotemOfHoldingEntityMixin
extends Entity {
    @Shadow
    private List<ItemStack> storedItems = new LinkedList<ItemStack>();

    public TotemOfHoldingEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Overwrite(remap=false)
    public boolean m_7313_(@NotNull Entity e) {
        if (!this.f_19853_.f_46443_ && e instanceof Player) {
            Player owner;
            Player player = (Player)e;
            if (!TotemOfHoldingModule.allowAnyoneToCollect && !player.m_150110_().f_35937_ && e != (owner = this.getOwnerEntity())) {
                return false;
            }
            int drops = Math.min(this.storedItems.size(), 3 + this.f_19853_.f_46441_.nextInt(4));
            for (int i = 0; i < drops; ++i) {
                ItemStack[] stack = new ItemStack[]{this.storedItems.remove(0)};
                if (this.isCurios(stack[0])) {
                    CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                        for (String identifier : CuriosApi.getCuriosHelper().getCurioTags(stack[0].m_41720_())) {
                            if (stack[0] == null) break;
                            handler.getStacksHandler(identifier).ifPresent(stacks -> {
                                IDynamicStackHandler dynamicStack = stacks.getStacks();
                                for (int slot = 0; slot < dynamicStack.getSlots(); ++slot) {
                                    if (!dynamicStack.getStackInSlot(slot).m_41619_()) continue;
                                    boolean flag = true;
                                    SlotContext context = null;
                                    LazyOptional curio = CuriosApi.getCuriosHelper().getCurio(stack[0]);
                                    if (curio.isPresent()) {
                                        NonNullList renders = stacks.getRenders();
                                        context = new SlotContext(identifier, (LivingEntity)player, slot, false, renders.size() > slot && (Boolean)renders.get(slot) != false);
                                        flag = ((ICurio)curio.resolve().get()).canEquip(context);
                                    }
                                    if (!flag) continue;
                                    dynamicStack.setStackInSlot(slot, stack[0]);
                                    stack[0] = null;
                                    if (curio.isPresent() && context != null) {
                                        ((ICurio)curio.resolve().get()).onEquip(context, ItemStack.f_41583_);
                                    }
                                    return;
                                }
                            });
                        }
                    });
                }
                if (stack[0] != null) {
                    ItemStack curr;
                    Item item = stack[0].m_41720_();
                    if (item instanceof ArmorItem) {
                        ArmorItem armor = (ArmorItem)item;
                        EquipmentSlot slot = armor.m_40402_();
                        ItemStack curr2 = player.m_6844_(slot);
                        if (curr2.m_41619_()) {
                            player.m_8061_(slot, stack[0]);
                            stack[0] = null;
                        } else if (!EnchantmentHelper.m_44920_((ItemStack)curr2) && !EnchantmentHelper.m_44920_((ItemStack)stack[0])) {
                            player.m_8061_(slot, stack[0]);
                            stack[0] = curr2;
                        }
                    } else if (stack[0].m_41720_() instanceof ShieldItem && (curr = player.m_6844_(EquipmentSlot.OFFHAND)).m_41619_()) {
                        player.m_8061_(EquipmentSlot.OFFHAND, stack[0]);
                        stack[0] = null;
                    }
                }
                if (stack[0] == null || player.m_36356_(stack[0])) continue;
                this.m_5552_(stack[0], 0.0f);
            }
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), drops, 0.1, 0.5, 0.1, 0.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), drops, 0.4, 0.5, 0.4, 0.0);
            }
        }
        return false;
    }

    private boolean isCurios(ItemStack stack) {
        return !CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).isEmpty();
    }

    @Shadow
    protected abstract Player getOwnerEntity();
}

