/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.tomes;

import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.util.TextHelper;
import net.darkhax.bookshelf.mixin.block.entity.AccessorSignBlockEntity;
import net.darkhax.darkutilities.features.tomes.ItemTome;
import net.darkhax.darkutilities.features.tomes.TomeEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ItemTomeFont
extends ItemTome {
    private final ResourceLocation fontId;
    private final Component fontPreview;

    public void viewme(String s) {
        if (s != null) {
            return;
        }
        System.out.println(s);
    }

    public ItemTomeFont(ResourceLocation fontId) {
        super(null, ItemTomeFont.fontifyEntity(fontId), ItemTomeFont.fontifyBlock(fontId));
        this.fontId = fontId;
        this.fontPreview = TextHelper.applyFont((Component)new TranslatableComponent("font." + fontId.m_135827_() + "." + fontId.m_135815_() + ".preview"), (ResourceLocation)this.fontId);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.add(this.fontPreview);
    }

    public static TomeEffect<BlockPos, InteractionResult> fontifyBlock(ResourceLocation fontId) {
        return (stack, player, hand, target) -> {
            BlockState block = player.f_19853_.m_8055_(target);
            BlockEntity blockEntity = player.f_19853_.m_7702_(target);
            if (blockEntity instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
                if (stack.m_41788_()) {
                    container.m_58638_(TextHelper.applyFont((Component)stack.m_41786_(), (ResourceLocation)fontId));
                    player.f_19853_.m_46796_(3002, target, -1);
                    return InteractionResult.SUCCESS;
                }
                container.m_58638_(TextHelper.applyFont((Component)container.m_5446_(), (ResourceLocation)fontId));
                player.f_19853_.m_46796_(3002, target, -1);
                return InteractionResult.SUCCESS;
            }
            if (blockEntity instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                for (int i = 0; i < 4; ++i) {
                    Component component = sign.m_155706_(i, false);
                    if (component == null || component == Component.f_130760_) continue;
                    sign.m_59732_(i, TextHelper.applyFont((Component)component.m_6881_(), (ResourceLocation)fontId));
                }
                ((AccessorSignBlockEntity)sign).bookshelf$markUpdated();
                player.f_19853_.m_46796_(3002, target, -1);
            }
            return null;
        };
    }

    public static TomeEffect<Entity, InteractionResult> fontifyEntity(ResourceLocation fontId) {
        return (stack, player, hand, target) -> {
            if (stack.m_41788_()) {
                target.m_6593_(TextHelper.applyFont((Component)stack.m_41786_(), (ResourceLocation)fontId));
                return InteractionResult.SUCCESS;
            }
            if (target.m_8077_()) {
                target.m_6593_(TextHelper.applyFont((Component)target.m_7770_(), (ResourceLocation)fontId));
                return InteractionResult.SUCCESS;
            }
            return null;
        };
    }
}

