/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableMap;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.dungeon.PlacementConfiguration;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.model.PlacementBehaviour;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;

public enum DungeonModelBlockType {
    AIR((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> DungeonBlocks.CAVE_AIR),
    SOLID(DungeonModelBlockType.tFactory(Theme::getSolid), new TypeBuilder(PlacementConfiguration::getSolid).expandable().placement(PlacementBehaviour.SOLID)),
    SOLID_STAIRS(DungeonModelBlockType.tFactory(Theme::getSolidStairs), new TypeBuilder(PlacementConfiguration::getSolidStairs).placement(PlacementBehaviour.SOLID)),
    SOLID_SLAB(DungeonModelBlockType.tFactory(Theme::getSolidSlab), new TypeBuilder(PlacementConfiguration::getSolidSlab).placement(PlacementBehaviour.SOLID)),
    GENERIC(DungeonModelBlockType.tFactory(Theme::getGeneric), new TypeBuilder(PlacementConfiguration::getGeneric).expandable()),
    GENERIC_OR_FENCING(DungeonModelBlockType.tFactory(Theme::getGeneric), new TypeBuilder(PlacementConfiguration::getGenericOrFencing).placement(PlacementBehaviour.NON_SOLID.withAirBlock((theme, secondaryTheme) -> theme.getFencing()))),
    SLAB(DungeonModelBlockType.tFactory(Theme::getSlab), PlacementConfiguration::getSlab),
    SOLID_PILLAR(DungeonModelBlockType.tFactory(Theme::getPillar), new TypeBuilder(PlacementConfiguration::getSolidPillar).expandable().pillar().placement(PlacementBehaviour.SOLID)),
    SOLID_FLOOR(DungeonModelBlockType.tFactory(Theme::getFloor), new TypeBuilder(PlacementConfiguration::getSolidFloor).expandable().placement(PlacementBehaviour.SOLID)),
    FENCING(DungeonModelBlockType.tFactory(Theme::getFencing), PlacementConfiguration::getFencing),
    FLOOR(DungeonModelBlockType.tFactory(Theme::getFloor), new TypeBuilder(PlacementConfiguration::getFloor).placement(PlacementBehaviour.SMALL_GRID)),
    FLUID(DungeonModelBlockType.tFactory(Theme::getFluid), PlacementConfiguration::getFluid),
    LOOSE_GROUND(DungeonModelBlockType.tFactory(Theme::getFloor), PlacementConfiguration::getLooseGround),
    STAIRS(DungeonModelBlockType.tFactory(Theme::getStairs), PlacementConfiguration::getStairs),
    WALL(DungeonModelBlockType.tFactory(Theme::getWall), PlacementConfiguration::getWall),
    PILLAR(DungeonModelBlockType.sFactory(SecondaryTheme::getPillar), new TypeBuilder(PlacementConfiguration::getPillar).expandable().pillar()),
    MATERIAL_STAIRS(DungeonModelBlockType.sFactory(SecondaryTheme::getStairs), PlacementConfiguration::getStairs),
    TRAPDOOR(DungeonModelBlockType.sFactory(SecondaryTheme::getTrapDoor), PlacementConfiguration::getTrapdoor),
    DOOR(DungeonModelBlockType.sFactory(SecondaryTheme::getDoor), PlacementConfiguration::getDoor),
    FENCE(DungeonModelBlockType.sFactory(SecondaryTheme::getFence), PlacementConfiguration::getFence),
    FENCE_GATE(DungeonModelBlockType.sFactory(SecondaryTheme::getFenceGate), PlacementConfiguration::getFenceGate),
    MATERIAL_SLAB(DungeonModelBlockType.sFactory(SecondaryTheme::getSlab), PlacementConfiguration::getSlab),
    MATERIAL_BUTTON(DungeonModelBlockType.sFactory(SecondaryTheme::getButton), PlacementConfiguration::getMaterialButton),
    MATERIAL_PRESSURE_PLATE(DungeonModelBlockType.sFactory(SecondaryTheme::getPressurePlate), PlacementConfiguration::getMaterialPressurePlate),
    MATERIAL(DungeonModelBlockType.sFactory(SecondaryTheme::getMaterial), new TypeBuilder(PlacementConfiguration::getMaterial).expandable()),
    CHEST((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(Blocks.f_50087_.m_49966_(), world, pos, rotation), PlacementConfiguration::getChest),
    SKULL((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> {
        BlockState state = block.create(Blocks.f_50310_.m_49966_(), world, pos, rotation);
        if (state.m_61138_((Property)BlockStateProperties.f_61390_)) {
            int r = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
            int add = rand.nextInt(3);
            if (rand.nextBoolean()) {
                if ((r -= add) < 0) {
                    r += 16;
                }
            } else {
                r = (r + add) % 16;
            }
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(r));
            return state;
        }
        return state;
    }, PlacementConfiguration::getSkull),
    CARPET((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> {
        Block b;
        Block block2 = b = block.variation != null && variation != null ? DungeonBlocks.CARPET[(block.variation + variation[block.variation % variation.length]) % DungeonBlocks.CARPET.length] : (Block)ForgeRegistries.BLOCKS.getValue(block.blockName);
        if (b == null) {
            b = DungeonBlocks.CARPET[rand.nextInt(DungeonBlocks.CARPET.length)];
        }
        return block.create(b.m_49966_());
    }, PlacementConfiguration::getCarpet),
    OTHER((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(block.getBlock().m_49966_(), world, pos, rotation), PlacementConfiguration::getOther);

    public static final ImmutableMap<String, DungeonModelBlockType> NAME_TO_TYPE;
    public final BlockFactory blockFactory;
    public final PlacementBehaviour defaultPlacementBehavior;
    public final Function<PlacementConfiguration, PlacementBehaviour> placementBehaviourFromConfig;
    private final boolean isPillar;
    private final boolean expandable;

    private DungeonModelBlockType(BlockFactory blockFactory) {
        this(blockFactory, (PlacementConfiguration config) -> PlacementBehaviour.NON_SOLID);
    }

    private DungeonModelBlockType(BlockFactory blockFactory, Function<PlacementConfiguration, PlacementBehaviour> placementBehaviourFromConfig) {
        this(blockFactory, new TypeBuilder(placementBehaviourFromConfig));
    }

    private DungeonModelBlockType(BlockFactory blockFactory, TypeBuilder typeBuilder) {
        this.blockFactory = blockFactory;
        this.defaultPlacementBehavior = typeBuilder.defaultPlacementBehaviour;
        this.placementBehaviourFromConfig = typeBuilder.placementBehaviourFromConfig;
        this.isPillar = typeBuilder.isPillar;
        this.expandable = typeBuilder.expandable;
    }

    public boolean isPillar() {
        return this.isPillar;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public static DungeonModelBlockType get(Block block, ModelBlockDefinition definition) {
        if (definition.containsBlock(block)) {
            return definition.getType(block);
        }
        if (definition.fallback != null && definition.fallback.containsBlock(block)) {
            return definition.fallback.getType(block);
        }
        return OTHER;
    }

    private static BlockFactory tFactory(Function<Theme, BlockStateProvider> blockSelector) {
        return (block, rotation, world, pos, theme, secondaryTheme, rand, variation, stage) -> block.create(((BlockStateProvider)blockSelector.apply(theme)).get(world, pos, rand, rotation), world, pos, rotation);
    }

    private static BlockFactory sFactory(Function<SecondaryTheme, BlockStateProvider> blockSelector) {
        return (block, rotation, world, pos, theme, secondaryTheme, rand, variation, stage) -> block.create(((BlockStateProvider)blockSelector.apply(secondaryTheme)).get(world, pos, rand, rotation), world, pos, rotation);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (DungeonModelBlockType type : DungeonModelBlockType.values()) {
            builder.put((Object)type.name(), (Object)type);
        }
        builder.put((Object)"NORMAL", (Object)GENERIC);
        builder.put((Object)"VANILLA_WALL", (Object)WALL);
        builder.put((Object)"WOODEN_BUTTON", (Object)MATERIAL_BUTTON);
        builder.put((Object)"WOODEN_SLAB", (Object)MATERIAL_SLAB);
        builder.put((Object)"WOODEN_PRESSURE_PLATE", (Object)MATERIAL_PRESSURE_PLATE);
        builder.put((Object)"NORMAL_2", (Object)AIR);
        builder.put((Object)"GENERIC_SECONDARY", (Object)AIR);
        builder.put((Object)"SPAWNER", (Object)AIR);
        builder.put((Object)"BARREL", (Object)AIR);
        NAME_TO_TYPE = builder.build();
    }

    @FunctionalInterface
    public static interface BlockFactory {
        public BlockState get(DungeonModelBlock var1, Rotation var2, LevelAccessor var3, BlockPos var4, Theme var5, SecondaryTheme var6, Random var7, byte[] var8, int var9);
    }

    private static class TypeBuilder {
        private PlacementBehaviour defaultPlacementBehaviour;
        private Function<PlacementConfiguration, PlacementBehaviour> placementBehaviourFromConfig;
        private boolean expandable;
        private boolean isPillar;

        private TypeBuilder(Function<PlacementConfiguration, PlacementBehaviour> placementBehaviourFromConfig) {
            this.placementBehaviourFromConfig = placementBehaviourFromConfig;
            this.defaultPlacementBehaviour = PlacementBehaviour.NON_SOLID;
            this.expandable = false;
            this.isPillar = false;
        }

        public TypeBuilder placement(@Nonnull PlacementBehaviour placementBehaviour) {
            this.defaultPlacementBehaviour = placementBehaviour;
            return this;
        }

        public TypeBuilder expandable() {
            this.expandable = true;
            return this;
        }

        public TypeBuilder pillar() {
            this.isPillar = true;
            return this;
        }
    }
}

