/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TreasureItems {
    public static final ItemStack LAUDANUM;
    public static final ItemStack ANIMUS;
    public static final ItemStack NECTAR;
    public static final ItemStack LUMA;
    public static final ItemStack VELOCITAS;
    public static final ItemStack POTION_HEALING;
    public static final ItemStack POTION_HEALING_II;
    public static final ItemStack POTION_REGENERATION;
    public static final ItemStack POTION_REGENERATION_LONG;
    public static final ItemStack POTION_REGENERATION_II;
    public static final ItemStack SPLASH_POISON;
    public static final ItemStack SPLASH_POISON_LONG;
    public static final ItemStack SPLASH_HARMING;
    public static final ItemStack SPLASH_HARMING_II;
    private static final ItemStack[] POTIONS;
    private static final ItemStack[] SPECIAL_POTIONS;

    public static CompoundTag createDisplayTag(String name, String ... loreEntries) {
        CompoundTag display = new CompoundTag();
        display.m_128365_("Name", (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent(name))));
        ListTag lore = new ListTag();
        if (loreEntries.length > 0) {
            for (String line : loreEntries) {
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent(line))));
            }
            display.m_128365_("Lore", (Tag)lore);
        }
        return display;
    }

    public static CompoundTag createPotionTag(String potionName) {
        CompoundTag potion = new CompoundTag();
        potion.m_128359_("Potion", potionName);
        return potion;
    }

    private static ItemStack createItemWithNbt(Item item, CompoundTag nbt) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41751_(nbt);
        return stack;
    }

    public static ItemStack getRandomSpecialPotion(Random rand, int stage) {
        if ((double)rand.nextFloat() < 0.4) {
            return POTIONS[rand.nextInt(POTIONS.length)].m_41777_();
        }
        if (stage == 0) {
            return LAUDANUM.m_41777_();
        }
        return SPECIAL_POTIONS[rand.nextInt(SPECIAL_POTIONS.length)].m_41777_();
    }

    static {
        CompoundTag nbt = new CompoundTag();
        ListTag customPotionEffects = new ListTag();
        CompoundTag nausea = new CompoundTag();
        nausea.m_128405_("Id", 9);
        nausea.m_128405_("Duration", 100);
        CompoundTag blindness = new CompoundTag();
        blindness.m_128405_("Id", 15);
        blindness.m_128405_("Duration", 100);
        CompoundTag weakness = new CompoundTag();
        weakness.m_128405_("Id", 18);
        weakness.m_128405_("Duration", 100);
        CompoundTag miningFatigue = new CompoundTag();
        miningFatigue.m_128405_("Id", 4);
        miningFatigue.m_128405_("Duration", 100);
        CompoundTag regeneration = new CompoundTag();
        regeneration.m_128405_("Id", 10);
        regeneration.m_128405_("Amplifier", 1);
        regeneration.m_128405_("Duration", 160);
        customPotionEffects.add((Object)regeneration);
        customPotionEffects.add((Object)blindness);
        customPotionEffects.add((Object)weakness);
        customPotionEffects.add((Object)miningFatigue);
        customPotionEffects.add((Object)nausea);
        nbt.m_128365_("CustomPotionEffects", (Tag)customPotionEffects);
        nbt.m_128405_("CustomPotionColor", 7014144);
        nbt.m_128405_("HideFlags", 32);
        CompoundTag display = new CompoundTag();
        ListTag lore = new ListTag();
        lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent("A medicinal tincture."))));
        display.m_128365_("Lore", (Tag)lore);
        display.m_128365_("Name", (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent("Laudanum"))));
        nbt.m_128365_("display", (Tag)display);
        LAUDANUM = new ItemStack((ItemLike)Items.f_42589_);
        LAUDANUM.m_41751_(nbt);
        nbt = new CompoundTag();
        customPotionEffects = new ListTag();
        CompoundTag wither = new CompoundTag();
        wither.m_128405_("Id", 20);
        wither.m_128405_("Duration", 40);
        blindness = new CompoundTag();
        blindness.m_128405_("Id", 15);
        blindness.m_128405_("Duration", 40);
        CompoundTag strength = new CompoundTag();
        strength.m_128405_("Id", 5);
        strength.m_128405_("Duration", 800);
        customPotionEffects.add((Object)strength);
        customPotionEffects.add((Object)blindness);
        customPotionEffects.add((Object)wither);
        nbt.m_128365_("CustomPotionEffects", (Tag)customPotionEffects);
        nbt.m_128405_("CustomPotionColor", 13050390);
        nbt.m_128405_("HideFlags", 32);
        CompoundTag display2 = new CompoundTag();
        ListTag lore2 = new ListTag();
        lore2.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent("An unstable mixture."))));
        display2.m_128365_("Lore", (Tag)lore2);
        display2.m_128365_("Name", (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent("Animus"))));
        nbt.m_128365_("display", (Tag)display2);
        ANIMUS = new ItemStack((ItemLike)Items.f_42589_);
        ANIMUS.m_41751_(nbt);
        nbt = new CompoundTag();
        customPotionEffects = new ListTag();
        CompoundTag resistance = new CompoundTag();
        resistance.m_128405_("Id", 11);
        resistance.m_128405_("Duration", 400);
        blindness = new CompoundTag();
        blindness.m_128405_("Id", 15);
        blindness.m_128405_("Duration", 100);
        CompoundTag absorption = new CompoundTag();
        absorption.m_128405_("Id", 22);
        absorption.m_128405_("Amplifier", 8);
        absorption.m_128405_("Duration", 600);
        customPotionEffects.add((Object)absorption);
        customPotionEffects.add((Object)resistance);
        customPotionEffects.add((Object)blindness);
        nbt.m_128365_("CustomPotionEffects", (Tag)customPotionEffects);
        nbt.m_128405_("CustomPotionColor", 15446551);
        nbt.m_128405_("HideFlags", 32);
        display2 = new CompoundTag();
        lore2 = new ListTag();
        lore2.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent("A floral extract."))));
        display2.m_128365_("Lore", (Tag)lore2);
        display2.m_128365_("Name", (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent("Nectar"))));
        nbt.m_128365_("display", (Tag)display2);
        NECTAR = new ItemStack((ItemLike)Items.f_42589_);
        NECTAR.m_41751_(nbt);
        nbt = new CompoundTag();
        customPotionEffects = new ListTag();
        CompoundTag speed = new CompoundTag();
        speed.m_128405_("Id", 1);
        speed.m_128405_("Amplifier", 1);
        speed.m_128405_("Duration", 400);
        blindness = new CompoundTag();
        blindness.m_128405_("Id", 15);
        blindness.m_128405_("Duration", 40);
        CompoundTag haste = new CompoundTag();
        haste.m_128405_("Id", 3);
        haste.m_128405_("Duration", 400);
        customPotionEffects.add((Object)speed);
        customPotionEffects.add((Object)haste);
        customPotionEffects.add((Object)blindness);
        nbt.m_128365_("CustomPotionEffects", (Tag)customPotionEffects);
        nbt.m_128405_("CustomPotionColor", 65327);
        nbt.m_128405_("HideFlags", 32);
        display2 = new CompoundTag();
        lore2 = new ListTag();
        lore2.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent("An energetic beverage."))));
        display2.m_128365_("Lore", (Tag)lore2);
        display2.m_128365_("Name", (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent("Velocitas"))));
        nbt.m_128365_("display", (Tag)display2);
        VELOCITAS = new ItemStack((ItemLike)Items.f_42589_);
        VELOCITAS.m_41751_(nbt);
        nbt = new CompoundTag();
        customPotionEffects = new ListTag();
        CompoundTag glowing = new CompoundTag();
        glowing.m_128405_("Id", 24);
        glowing.m_128405_("Duration", 12000);
        customPotionEffects.add((Object)glowing);
        nbt.m_128365_("CustomPotionEffects", (Tag)customPotionEffects);
        nbt.m_128405_("CustomPotionColor", 0xFAFA00);
        nbt.m_128405_("HideFlags", 32);
        CompoundTag display3 = new CompoundTag();
        ListTag lore3 = new ListTag();
        lore3.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent("A glowstone extract."))));
        display3.m_128365_("Lore", (Tag)lore3);
        display3.m_128365_("Name", (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent("Luma"))));
        nbt.m_128365_("display", (Tag)display3);
        LUMA = new ItemStack((ItemLike)Items.f_42589_);
        LUMA.m_41751_(nbt);
        POTION_HEALING = TreasureItems.createItemWithNbt(Items.f_42589_, TreasureItems.createPotionTag("minecraft:healing"));
        POTION_HEALING_II = TreasureItems.createItemWithNbt(Items.f_42589_, TreasureItems.createPotionTag("minecraft:strong_healing"));
        POTION_REGENERATION = TreasureItems.createItemWithNbt(Items.f_42589_, TreasureItems.createPotionTag("minecraft:regeneration"));
        POTION_REGENERATION_LONG = TreasureItems.createItemWithNbt(Items.f_42589_, TreasureItems.createPotionTag("minecraft:long_regeneration"));
        POTION_REGENERATION_II = TreasureItems.createItemWithNbt(Items.f_42589_, TreasureItems.createPotionTag("minecraft:strong_regeneration"));
        SPLASH_POISON = TreasureItems.createItemWithNbt(Items.f_42589_, TreasureItems.createPotionTag("minecraft:poison"));
        SPLASH_POISON_LONG = TreasureItems.createItemWithNbt(Items.f_42589_, TreasureItems.createPotionTag("minecraft:long_poison"));
        SPLASH_HARMING = TreasureItems.createItemWithNbt(Items.f_42589_, TreasureItems.createPotionTag("minecraft:harming"));
        SPLASH_HARMING_II = TreasureItems.createItemWithNbt(Items.f_42589_, TreasureItems.createPotionTag("minecraft:strong_harming"));
        POTIONS = new ItemStack[]{POTION_HEALING, POTION_HEALING_II, POTION_REGENERATION, POTION_REGENERATION_LONG, POTION_REGENERATION_II, SPLASH_HARMING, SPLASH_HARMING_II, SPLASH_POISON, SPLASH_POISON_LONG};
        SPECIAL_POTIONS = new ItemStack[]{LAUDANUM, ANIMUS, NECTAR, LUMA, VELOCITAS};
    }
}

