/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.block.SkilletBlock;
import vectorwing.farmersdelight.common.block.entity.SkilletBlockEntity;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SkilletItem
extends BlockItem {
    public static final Tiers SKILLET_TIER = Tiers.IRON;
    private final Multimap<Attribute, AttributeModifier> toolAttributes;

    public SkilletItem(Block block, Item.Properties properties) {
        super(block, properties.m_41499_(SKILLET_TIER.m_6609_()));
        float attackDamage = 5.0f + SKILLET_TIER.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-3.1f, AttributeModifier.Operation.ADDITION));
        this.toolAttributes = builder.build();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    private static boolean isPlayerNearHeatSource(Player player, LevelReader level) {
        if (player.m_6060_()) {
            return true;
        }
        BlockPos pos = player.m_142538_();
        for (BlockPos nearbyPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-1, -1, -1), (BlockPos)pos.m_142082_(1, 1, 1))) {
            if (!level.m_8055_(nearbyPos).m_204336_(ModTags.HEAT_SOURCES)) continue;
            return true;
        }
        return false;
    }

    public int m_8105_(ItemStack stack) {
        int fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack);
        int cookingTime = stack.m_41784_().m_128451_("CookTimeHandheld");
        return SkilletBlock.getSkilletCookingTime(cookingTime, fireAspectLevel);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack skilletStack = player.m_21120_(hand);
        if (SkilletItem.isPlayerNearHeatSource(player, (LevelReader)level)) {
            InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            ItemStack cookingStack = player.m_21120_(otherHand);
            if (skilletStack.m_41784_().m_128441_("Cooking")) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19098_((Object)skilletStack);
            }
            Optional<CampfireCookingRecipe> recipe = SkilletItem.getCookingRecipe(cookingStack, level);
            if (recipe.isPresent()) {
                ItemStack cookingStackCopy = cookingStack.m_41777_();
                ItemStack cookingStackUnit = cookingStackCopy.m_41620_(1);
                skilletStack.m_41784_().m_128365_("Cooking", (Tag)cookingStackUnit.serializeNBT());
                skilletStack.m_41784_().m_128405_("CookTimeHandheld", recipe.get().m_43753_());
                player.m_6672_(hand);
                player.m_21008_(otherHand, cookingStackCopy);
                return InteractionResultHolder.m_19096_((Object)skilletStack);
            }
            player.m_5661_((Component)TextUtils.getTranslation("item.skillet.how_to_cook", new Object[0]), true);
        }
        return InteractionResultHolder.m_19098_((Object)skilletStack);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Vec3 pos = player.m_20182_();
            double x = pos.m_7096_() + 0.5;
            double y = pos.m_7098_();
            double z = pos.m_7094_() + 0.5;
            if (level.f_46441_.nextInt(50) == 0) {
                level.m_7785_(x, y, z, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get(), SoundSource.BLOCKS, 0.4f, level.f_46441_.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_("Cooking")) {
                ItemStack cookingStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Cooking"));
                player.m_150109_().m_150079_(cookingStack);
                tag.m_128473_("Cooking");
                tag.m_128473_("CookTimeHandheld");
            }
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_("Cooking")) {
                ItemStack cookingStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Cooking"));
                Optional<CampfireCookingRecipe> cookingRecipe = SkilletItem.getCookingRecipe(cookingStack, level);
                cookingRecipe.ifPresent(recipe -> {
                    ItemStack resultStack = recipe.m_5874_((Container)new SimpleContainer(new ItemStack[0]));
                    if (!player.m_150109_().m_36054_(resultStack)) {
                        player.m_36176_(resultStack, false);
                    }
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, stack);
                    }
                });
                tag.m_128473_("Cooking");
                tag.m_128473_("CookTimeHandheld");
            }
        }
        return stack;
    }

    public static Optional<CampfireCookingRecipe> getCookingRecipe(ItemStack stack, Level level) {
        if (stack.m_41619_()) {
            return Optional.empty();
        }
        return level.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{stack}), level);
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        super.m_7274_(pos, level, player, stack, state);
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof SkilletBlockEntity) {
            SkilletBlockEntity skillet = (SkilletBlockEntity)tileEntity;
            skillet.setSkilletItem(stack);
            return true;
        }
        return false;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return SKILLET_TIER.m_6282_().test(repair) || super.m_6832_(toRepair, repair);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!level.f_46443_ && state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            stack.m_41622_(1, entity, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        if (player != null && player.m_6144_()) {
            return super.m_40576_(context);
        }
        return InteractionResult.PASS;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_.equals((Object)EnchantmentCategory.WEAPON)) {
            HashSet DENIED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.f_44983_});
            return !DENIED_ENCHANTMENTS.contains(enchantment);
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public int m_6473_() {
        return SKILLET_TIER.m_6601_();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.toolAttributes : super.m_7167_(equipmentSlot);
    }

    @Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class SkilletEvents {
        @SubscribeEvent
        public static void onSkilletKnockback(LivingKnockBackEvent event) {
            ItemStack tool;
            LivingEntity attacker = event.getEntityLiving().m_21232_();
            ItemStack itemStack = tool = attacker != null ? attacker.m_21120_(InteractionHand.MAIN_HAND) : ItemStack.f_41583_;
            if (tool.m_41720_() instanceof SkilletItem) {
                event.setStrength(event.getOriginalStrength() * 2.0f);
            }
        }

        @SubscribeEvent
        public static void onSkilletAttack(AttackEntityEvent event) {
            Player player = event.getPlayer();
            float attackPower = player.m_36403_(0.0f);
            ItemStack tool = player.m_21120_(InteractionHand.MAIN_HAND);
            if (tool.m_41720_() instanceof SkilletItem) {
                if (attackPower > 0.8f) {
                    float pitch = 0.9f + player.m_21187_().nextFloat() * 0.2f;
                    player.m_20193_().m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.ITEM_SKILLET_ATTACK_STRONG.get(), SoundSource.PLAYERS, 1.0f, pitch);
                } else {
                    player.m_20193_().m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.ITEM_SKILLET_ATTACK_WEAK.get(), SoundSource.PLAYERS, 0.8f, 0.9f);
                }
            }
        }
    }
}

