/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.item.enchantment;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.registry.ModEnchantments;

public class BackstabbingEnchantment
extends Enchantment {
    public BackstabbingEnchantment(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot ... applicableSlots) {
        super(rarity, category, applicableSlots);
    }

    public int m_44702_() {
        return 1;
    }

    public int m_6586_() {
        return 3;
    }

    public int m_6183_(int enchantmentLevel) {
        return 15 + (enchantmentLevel - 1) * 9;
    }

    public int m_6175_(int enchantmentLevel) {
        return super.m_6183_(enchantmentLevel) + 50;
    }

    public static boolean isLookingBehindTarget(LivingEntity target, Vec3 attackerLocation) {
        if (attackerLocation != null) {
            Vec3 lookingVector = target.m_20252_(1.0f);
            Vec3 attackAngleVector = attackerLocation.m_82546_(target.m_20182_()).m_82541_();
            attackAngleVector = new Vec3(attackAngleVector.f_82479_, 0.0, attackAngleVector.f_82481_);
            return attackAngleVector.m_82526_(lookingVector) < -0.5;
        }
        return false;
    }

    public static float getBackstabbingDamagePerLevel(float amount, int level) {
        float multiplier = (float)level * 0.2f + 1.2f;
        return amount * multiplier;
    }

    @Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class BackstabbingEvent {
        @SubscribeEvent
        public static void onKnifeBackstab(LivingHurtEvent event) {
            Entity attacker = event.getSource().m_7639_();
            if (attacker instanceof Player) {
                ItemStack weapon = ((Player)attacker).m_21205_();
                int enchantmentLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.BACKSTABBING.get()), (ItemStack)weapon);
                if (enchantmentLevel > 0 && BackstabbingEnchantment.isLookingBehindTarget(event.getEntityLiving(), event.getSource().m_7270_())) {
                    Level level = event.getEntityLiving().m_20193_();
                    if (!level.f_46443_) {
                        event.setAmount(BackstabbingEnchantment.getBackstabbingDamagePerLevel(event.getAmount(), enchantmentLevel));
                        level.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12313_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }
}

