/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.LogicHelper;

public class ColoredBlockModel
implements IModelGeometry<ColoredBlockModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final List<ColorData> colorData;

    public List<BlockElement> getElements() {
        return this.model.getElements();
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    public static void bakePart(SimpleBakedModel.Builder builder, IModelConfiguration owner, BlockElement part, int color, int luminosity, ModelState transform, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        ColoredBlockModel.bakePart(builder, owner, part, color, luminosity, transform.m_6189_(), transform.m_7538_(), spriteGetter, location);
    }

    public static void bakePart(SimpleBakedModel.Builder builder, IModelConfiguration owner, BlockElement part, int color, int luminosity, Transformation transform, boolean uvlock, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        for (Direction direction : part.f_111310_.keySet()) {
            BlockElementFace face = (BlockElementFace)part.f_111310_.get(direction);
            String texture = face.f_111356_;
            if (texture.charAt(0) == '#') {
                texture = texture.substring(1);
            }
            TextureAtlasSprite sprite = spriteGetter.apply(owner.resolveTexture(texture));
            BakedQuad quad = ColoredBlockModel.bakeFace(part, face, sprite, direction, transform, uvlock, color, luminosity, location);
            if (face.f_111354_ == null) {
                builder.m_119526_(quad);
                continue;
            }
            builder.m_119530_(Direction.m_122384_((Matrix4f)transform.m_121104_(), (Direction)face.f_111354_), quad);
        }
    }

    public static BakedModel bakeModel(IModelConfiguration owner, List<BlockElement> elements, List<ColorData> colorData, ModelState transform, ItemOverrides overrides, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(owner, overrides).m_119528_(particle);
        int size = elements.size();
        Transformation transformation = transform.m_6189_();
        boolean uvlock = transform.m_7538_();
        for (int i = 0; i < size; ++i) {
            BlockElement part = elements.get(i);
            ColorData colors = LogicHelper.getOrDefault(colorData, i, ColorData.DEFAULT);
            ColoredBlockModel.bakePart(builder, owner, part, colors.color, colors.luminosity(), transformation, colors.isUvLock(uvlock), spriteGetter, location);
        }
        return builder.m_119533_();
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return ColoredBlockModel.bakeModel(owner, this.model.getElements(), this.colorData, modelTransform, overrides, spriteGetter, modelLocation);
    }

    public BakedModel bakeDynamic(IModelConfiguration owner, ModelState transform) {
        return ColoredBlockModel.bakeModel(owner, this.getElements(), this.colorData, transform, ItemOverrides.f_111734_, ForgeModelBakery.defaultTextureGetter(), SimpleBlockModel.BAKE_LOCATION);
    }

    public static ColoredBlockModel deserialize(JsonDeserializationContext context, JsonObject json) {
        SimpleBlockModel model = SimpleBlockModel.deserialize(context, json);
        List<ColorData> colorData = json.has("colors") ? JsonHelper.parseList(json, "colors", ColorData::fromJson) : Collections.emptyList();
        return new ColoredBlockModel(model, colorData);
    }

    @Deprecated
    public static BakedQuad bakeFace(BlockElement part, BlockElementFace face, TextureAtlasSprite sprite, Direction facing, ModelState transform, int color, int luminosity, ResourceLocation location) {
        return ColoredBlockModel.bakeFace(part, face, sprite, facing, transform.m_6189_(), transform.m_7538_(), color, luminosity, location);
    }

    public static BakedQuad bakeFace(BlockElement part, BlockElementFace face, TextureAtlasSprite sprite, Direction facing, Transformation transform, boolean uvlock, int color, int luminosity, ResourceLocation location) {
        return ColoredBlockModel.bakeQuad(part.f_111308_, part.f_111309_, face, sprite, facing, transform, uvlock, part.f_111311_, part.f_111312_, color, luminosity, location);
    }

    @Deprecated
    public static BakedQuad bakeQuad(Vector3f posFrom, Vector3f posTo, BlockElementFace face, TextureAtlasSprite sprite, Direction facing, ModelState transform, @Nullable BlockElementRotation partRotation, boolean shade, int color, int luminosity, ResourceLocation location) {
        return ColoredBlockModel.bakeQuad(posFrom, posTo, face, sprite, facing, transform.m_6189_(), transform.m_7538_(), partRotation, shade, color, luminosity, location);
    }

    public static BakedQuad bakeQuad(Vector3f posFrom, Vector3f posTo, BlockElementFace face, TextureAtlasSprite sprite, Direction facing, Transformation transform, boolean uvlock, @Nullable BlockElementRotation partRotation, boolean shade, int color, int luminosity, ResourceLocation location) {
        BlockFaceUV faceUV = face.f_111357_;
        if (uvlock) {
            faceUV = FaceBakery.m_111581_((BlockFaceUV)face.f_111357_, (Direction)facing, (Transformation)transform, (ResourceLocation)location);
        }
        float[] originalUV = new float[faceUV.f_111387_.length];
        System.arraycopy(faceUV.f_111387_, 0, originalUV, 0, originalUV.length);
        float shrinkRatio = sprite.m_118417_();
        float u = (faceUV.f_111387_[0] + faceUV.f_111387_[0] + faceUV.f_111387_[2] + faceUV.f_111387_[2]) / 4.0f;
        float v = (faceUV.f_111387_[1] + faceUV.f_111387_[1] + faceUV.f_111387_[3] + faceUV.f_111387_[3]) / 4.0f;
        faceUV.f_111387_[0] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[0], (float)u);
        faceUV.f_111387_[2] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[2], (float)u);
        faceUV.f_111387_[1] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[1], (float)v);
        faceUV.f_111387_[3] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[3], (float)v);
        int[] vertexData = ColoredBlockModel.makeVertices(faceUV, sprite, facing, BlockModel.f_111421_.m_111592_(posFrom, posTo), transform, partRotation, color, luminosity);
        Direction direction = FaceBakery.m_111612_((int[])vertexData);
        System.arraycopy(originalUV, 0, faceUV.f_111387_, 0, originalUV.length);
        if (partRotation == null) {
            BlockModel.f_111421_.m_111630_(vertexData, direction);
        }
        ForgeHooksClient.fillNormal((int[])vertexData, (Direction)direction);
        return new BakedQuad(vertexData, face.f_111355_, direction, sprite, shade);
    }

    private static int[] makeVertices(BlockFaceUV uvs, TextureAtlasSprite sprite, Direction orientation, float[] posDiv16, Transformation rotationIn, @Nullable BlockElementRotation partRotation, int color, int luminosity) {
        int[] vertexData = new int[32];
        for (int i = 0; i < 4; ++i) {
            ColoredBlockModel.bakeVertex(vertexData, i, orientation, uvs, posDiv16, sprite, rotationIn, partRotation, color, luminosity);
        }
        return vertexData;
    }

    private static void bakeVertex(int[] vertexData, int vertexIndex, Direction facing, BlockFaceUV blockFaceUVIn, float[] posDiv16, TextureAtlasSprite sprite, Transformation rotationIn, @Nullable BlockElementRotation partRotation, int color, int luminosity) {
        FaceInfo.VertexInfo vertexInfo = FaceInfo.m_108984_((Direction)facing).m_108982_(vertexIndex);
        Vector3f vector3f = new Vector3f(posDiv16[vertexInfo.f_108998_], posDiv16[vertexInfo.f_108999_], posDiv16[vertexInfo.f_109000_]);
        BlockModel.f_111421_.m_111586_(vector3f, partRotation);
        BlockModel.f_111421_.m_111589_(vector3f, rotationIn);
        ColoredBlockModel.fillVertex(vertexData, vertexIndex, vector3f, sprite, blockFaceUVIn, color, luminosity);
    }

    private static int swapColorRedBlue(int color) {
        return color & 0xFF00FF00 | color >> 16 & 0xFF | color << 16 & 0xFF0000;
    }

    private static void fillVertex(int[] vertexData, int vertexIndex, Vector3f vector, TextureAtlasSprite sprite, BlockFaceUV blockFaceUV, int color, int luminosity) {
        int i = vertexIndex * 8;
        vertexData[i] = Float.floatToRawIntBits(vector.m_122239_());
        vertexData[i + 1] = Float.floatToRawIntBits(vector.m_122260_());
        vertexData[i + 2] = Float.floatToRawIntBits(vector.m_122269_());
        vertexData[i + 3] = ColoredBlockModel.swapColorRedBlue(color);
        vertexData[i + 4] = Float.floatToRawIntBits(sprite.m_118367_((double)blockFaceUV.m_111392_(vertexIndex) * 0.999 + (double)blockFaceUV.m_111392_((vertexIndex + 2) % 4) * 0.001));
        vertexData[i + 5] = Float.floatToRawIntBits(sprite.m_118393_((double)blockFaceUV.m_111396_(vertexIndex) * 0.999 + (double)blockFaceUV.m_111396_((vertexIndex + 2) % 4) * 0.001));
        vertexData[i + 6] = luminosity << 4;
    }

    public ColoredBlockModel(SimpleBlockModel model, List<ColorData> colorData) {
        this.model = model;
        this.colorData = colorData;
    }

    public SimpleBlockModel getModel() {
        return this.model;
    }

    public List<ColorData> getColorData() {
        return this.colorData;
    }

    public record ColorData(int color, int luminosity, @Nullable Boolean uvlock) {
        public static final ColorData DEFAULT = new ColorData(-1, 0, null);

        @Deprecated
        public ColorData(int color, int luminosity) {
            this(color, luminosity, null);
        }

        public boolean isUvLock(boolean defaultLock) {
            if (this.uvlock == null) {
                return defaultLock;
            }
            return this.uvlock;
        }

        public static ColorData fromJson(JsonObject json) {
            int color = JsonHelper.parseColor(GsonHelper.m_13851_((JsonObject)json, (String)"color", (String)""));
            int luminosity = GsonHelper.m_13824_((JsonObject)json, (String)"luminosity", (int)0);
            Boolean uvlock = null;
            if (json.has("uvlock")) {
                uvlock = GsonHelper.m_13912_((JsonObject)json, (String)"uvlock");
            }
            return new ColorData(color, luminosity, uvlock);
        }
    }

    private static class Loader
    implements IModelLoader<ColoredBlockModel> {
        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public ColoredBlockModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return ColoredBlockModel.deserialize(deserializationContext, modelContents);
        }
    }
}

