/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.mojang.datafixers.util.Either;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraftforge.client.model.IModelConfiguration;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class ModelTextureIteratable
implements Iterable<Map<String, Either<Material, String>>> {
    @Nullable
    private final Map<String, Either<Material, String>> startMap;
    @Nullable
    private final BlockModel startModel;

    public ModelTextureIteratable(BlockModel model) {
        this(null, model);
    }

    public static ModelTextureIteratable of(IModelConfiguration owner, SimpleBlockModel fallback) {
        UnbakedModel unbaked = owner.getOwnerModel();
        if (unbaked instanceof BlockModel) {
            return new ModelTextureIteratable(null, (BlockModel)unbaked);
        }
        return new ModelTextureIteratable(fallback.getTextures(), fallback.getParent());
    }

    public MapIterator iterator() {
        return new MapIterator(this.startMap, this.startModel);
    }

    public ModelTextureIteratable(@Nullable Map<String, Either<Material, String>> startMap, @Nullable BlockModel startModel) {
        this.startMap = startMap;
        this.startModel = startModel;
    }

    private static class MapIterator
    implements Iterator<Map<String, Either<Material, String>>> {
        @Nullable
        private Map<String, Either<Material, String>> initial;
        @Nullable
        private BlockModel model;

        @Override
        public boolean hasNext() {
            return this.initial != null || this.model != null;
        }

        @Override
        public Map<String, Either<Material, String>> next() {
            Map map;
            if (this.initial != null) {
                map = this.initial;
                this.initial = null;
            } else if (this.model != null) {
                map = this.model.f_111417_;
                this.model = this.model.f_111418_;
            } else {
                throw new NoSuchElementException();
            }
            return map;
        }

        public MapIterator(@Nullable Map<String, Either<Material, String>> initial, @Nullable BlockModel model) {
            this.initial = initial;
            this.model = model;
        }
    }
}

