/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.recipe.MantleRecipeSerializers;
import slimeknights.mantle.util.JsonHelper;

public class ShapedRetexturedRecipe
extends ShapedRecipe {
    private final Ingredient texture;
    private final boolean matchAll;

    protected ShapedRetexturedRecipe(ShapedRecipe orig, Ingredient texture, boolean matchAll) {
        super(orig.m_6423_(), orig.m_6076_(), orig.m_44220_(), orig.m_44221_(), orig.m_7527_(), orig.m_8043_());
        this.texture = texture;
        this.matchAll = matchAll;
    }

    public ItemStack getRecipeOutput(Item texture) {
        return RetexturedBlockItem.setTexture(this.m_8043_().m_41777_(), Block.m_49814_((Item)texture));
    }

    public ItemStack m_5874_(CraftingContainer craftMatrix) {
        ItemStack result = super.m_5874_(craftMatrix);
        Block currentTexture = null;
        for (int i = 0; i < craftMatrix.m_6643_(); ++i) {
            Block block;
            ItemStack stack = craftMatrix.m_8020_(i);
            if (stack.m_41619_() || !this.texture.test(stack) || (block = stack.m_41720_() == result.m_41720_() ? RetexturedBlockItem.getTexture(stack) : Block.m_49814_((Item)stack.m_41720_())) == Blocks.f_50016_) continue;
            if (currentTexture == null) {
                currentTexture = block;
                if (this.matchAll) continue;
                break;
            }
            if (currentTexture == block) continue;
            currentTexture = null;
            break;
        }
        if (currentTexture != null) {
            return RetexturedBlockItem.setTexture(result, currentTexture);
        }
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return MantleRecipeSerializers.CRAFTING_SHAPED_RETEXTURED;
    }

    public Ingredient getTexture() {
        return this.texture;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapedRetexturedRecipe> {
        public ShapedRetexturedRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = (ShapedRecipe)f_44076_.m_6729_(recipeId, json);
            Ingredient texture = CraftingHelper.getIngredient((JsonElement)JsonHelper.getElement(json, "texture"));
            boolean matchAll = false;
            if (json.has("match_all")) {
                matchAll = json.get("match_all").getAsBoolean();
            }
            return new ShapedRetexturedRecipe(recipe, texture, matchAll);
        }

        @Nullable
        public ShapedRetexturedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe recipe = (ShapedRecipe)f_44076_.m_8005_(recipeId, buffer);
            return recipe == null ? null : new ShapedRetexturedRecipe(recipe, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readBoolean());
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedRetexturedRecipe recipe) {
            f_44076_.m_6178_(buffer, (Recipe)recipe);
            recipe.texture.m_43923_(buffer);
            buffer.writeBoolean(recipe.matchAll);
        }
    }
}

