/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class FluidObject<F extends ForgeFlowingFluid>
implements Supplier<F>,
ItemLike {
    @Nonnull
    protected final ResourceLocation id;
    @Nonnull
    private final TagKey<Fluid> localTag;
    @Nonnull
    private final TagKey<Fluid> forgeTag;
    private final Supplier<? extends F> still;
    private final Supplier<? extends F> flowing;
    @Nullable
    private final Supplier<? extends LiquidBlock> block;

    public FluidObject(ResourceLocation id, String tagName, Supplier<? extends F> still, Supplier<? extends F> flowing, @Nullable Supplier<? extends LiquidBlock> block) {
        this.id = id;
        this.localTag = FluidTags.create((ResourceLocation)id);
        this.forgeTag = FluidTags.create((ResourceLocation)new ResourceLocation("forge", tagName));
        this.still = still;
        this.flowing = flowing;
        this.block = block;
    }

    public F getStill() {
        return (F)Objects.requireNonNull((ForgeFlowingFluid)this.still.get(), "Fluid object missing still fluid");
    }

    @Override
    public F get() {
        return this.getStill();
    }

    public F getFlowing() {
        return (F)Objects.requireNonNull((ForgeFlowingFluid)this.flowing.get(), "Fluid object missing flowing fluid");
    }

    @Nullable
    public LiquidBlock getBlock() {
        if (this.block == null) {
            return null;
        }
        return this.block.get();
    }

    public Item m_5456_() {
        return ((ForgeFlowingFluid)this.still.get()).m_6859_();
    }

    @Nonnull
    public ResourceLocation getId() {
        return this.id;
    }

    @Nonnull
    public TagKey<Fluid> getLocalTag() {
        return this.localTag;
    }

    @Nonnull
    public TagKey<Fluid> getForgeTag() {
        return this.forgeTag;
    }
}

