/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;

public class BYGTreeConfig
implements FeatureConfiguration {
    public static final Codec<BYGTreeConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.f_68747_.fieldOf("trunk_provider").orElse((Object)SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_())).forGetter(config -> config.trunkProvider), (App)BlockStateProvider.f_68747_.fieldOf("leaves_provider").orElse((Object)SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_())).forGetter(config -> config.leavesProvider), (App)BlockStateProvider.f_68747_.fieldOf("disk_provider").orElse((Object)SimpleStateProvider.m_191384_((BlockState)Blocks.f_50599_.m_49966_())).forGetter(config -> config.diskProvider), (App)Codec.INT.fieldOf("min_height").orElse((Object)15).forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_height").orElse((Object)15).forGetter(config -> config.maxHeight), (App)Codec.INT.fieldOf("disk_radius").orElse((Object)0).forGetter(config -> config.diskRadius), (App)BlockState.f_61039_.listOf().fieldOf("whitelist").forGetter(config -> config.whitelist.stream().map(Block::m_49966_).collect(Collectors.toList()))).apply((Applicative)codecRecorder, BYGTreeConfig::new));
    private final BlockStateProvider trunkProvider;
    private final BlockStateProvider leavesProvider;
    private final BlockStateProvider diskProvider;
    private final int minHeight;
    private final int maxHeight;
    private final int diskRadius;
    private final Set<Block> whitelist;
    private Rotation rotation = Rotation.NONE;
    private Mirror mirror = Mirror.NONE;

    BYGTreeConfig(BlockStateProvider trunkProvider, BlockStateProvider leavesProvider, BlockStateProvider diskProvider, int minHeight, int maxHeight, int diskRadius, List<BlockState> whitelist) {
        this.trunkProvider = trunkProvider;
        this.leavesProvider = leavesProvider;
        this.diskProvider = diskProvider;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.diskRadius = diskRadius;
        this.whitelist = whitelist.stream().map(BlockBehaviour.BlockStateBase::m_60734_).collect(Collectors.toSet());
    }

    public BlockStateProvider getTrunkProvider() {
        return this.trunkProvider;
    }

    public BlockStateProvider getLeavesProvider() {
        return this.leavesProvider;
    }

    public BlockStateProvider getDiskProvider() {
        return this.diskProvider;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getDiskRadius() {
        return this.diskRadius;
    }

    public Set<Block> getWhitelist() {
        return this.whitelist;
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public void setRotationAndMirror(Rotation rotation, Mirror mirror) {
        this.rotation = rotation;
        this.mirror = mirror;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public static class Builder {
        private BlockStateProvider trunkProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
        private BlockStateProvider leavesProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
        @Deprecated
        private BlockStateProvider groundReplacementProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50493_.m_49966_());
        private BlockStateProvider diskProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50599_.m_49966_());
        private List<Block> whitelist = ImmutableList.of((Object)Blocks.f_50440_);
        private int minHeight = 15;
        private int maxPossibleHeight = 1;
        private int diskRadius = 0;

        public Builder setTrunkBlock(Block block) {
            this.trunkProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
            return this;
        }

        public Builder setTrunkBlock(BlockState state) {
            this.trunkProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
            return this;
        }

        public Builder setTrunkBlock(BlockStateProvider stateProvider) {
            this.trunkProvider = stateProvider != null ? stateProvider : SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
            return this;
        }

        public Builder setLeavesBlock(Block block) {
            this.leavesProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setLeavesBlock(BlockState state) {
            this.leavesProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setLeavesBlock(BlockStateProvider stateProvider) {
            this.leavesProvider = stateProvider != null ? stateProvider : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setDiskBlock(Block block) {
            this.diskProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50016_.m_49966_());
            return this;
        }

        public Builder setDiskBlock(BlockState state) {
            this.diskProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50016_.m_49966_());
            return this;
        }

        public Builder setDiskBlock(BlockStateProvider stateProvider) {
            this.diskProvider = stateProvider != null ? stateProvider : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setMinHeight(int minHeight) {
            this.minHeight = minHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxPossibleHeight = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder setDiskRadius(int diskRadius) {
            this.diskRadius = Math.abs(diskRadius);
            return this;
        }

        public Builder setWhitelist(ImmutableList<Block> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public Builder copy(BYGTreeConfig config) {
            this.trunkProvider = config.trunkProvider;
            this.leavesProvider = config.leavesProvider;
            this.diskProvider = config.diskProvider;
            this.maxPossibleHeight = config.maxHeight;
            this.minHeight = config.minHeight;
            this.diskRadius = config.diskRadius;
            this.whitelist = ImmutableList.copyOf(config.whitelist);
            return this;
        }

        public BYGTreeConfig build() {
            return new BYGTreeConfig(this.trunkProvider, this.leavesProvider, this.diskProvider, this.minHeight, this.maxPossibleHeight, this.diskRadius, this.whitelist.stream().map(Block::m_49966_).collect(Collectors.toList()));
        }
    }
}

