/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.datagen.providers;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;
import potionstudios.byg.common.block.BYGBlockTags;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.mixin.access.TagBuilderAccess;
import potionstudios.byg.reg.RegistryObject;

public class BYGBlockTagsProvider
extends TagsProvider<Block> {
    public BYGBlockTagsProvider(DataGenerator pGenerator, @Nullable ExistingFileHelper existingFileHelper) {
        super(pGenerator, (Registry)Registry.f_122824_, "byg", existingFileHelper);
    }

    protected void m_6577_() {
        this.tag(BYGBlockTags.LUSH, BYGBlocks.LUSH_GRASS_PATH, BYGBlocks.LUSH_GRASS_BLOCK, BYGBlocks.LUSH_FARMLAND);
        this.m_206424_(BYGBlockTags.GROUND_MANGROVE_TREE).addTags(new TagKey[]{BlockTags.f_144274_, BlockTags.f_13029_}).m_126584_((Object[])new Block[]{(Block)BYGBlocks.MUD_BLOCK.get(), Blocks.f_50129_});
        TagsProvider.TagAppender slabsTag = super.m_206424_(BYGBlockTags.SLABS);
        BYGBlocks.PROVIDER.getEntries().stream().map(RegistryObject::get).filter(SlabBlock.class::isInstance).forEach(arg_0 -> ((TagsProvider.TagAppender)slabsTag).m_126582_(arg_0));
        this.m_206424_(BYGBlockTags.END_STONE).m_126584_((Object[])new Block[]{(Block)BYGBlocks.ETHER_STONE.get(), (Block)BYGBlocks.BULBIS_PHYCELIUM.get(), (Block)BYGBlocks.NIGHTSHADE_PHYLIUM.get(), (Block)BYGBlocks.IMPARIUS_PHYLIUM.get(), (Block)BYGBlocks.IVIS_PHYLIUM.get(), (Block)BYGBlocks.SHULKREN_PHYLIUM.get(), Blocks.f_50259_});
        for (TagKey<Block> netherPlantTag : BYGBlockTags.END_PLANT_TAGS) {
            this.m_206424_(netherPlantTag).m_126582_((Object)Blocks.f_50259_).m_206428_(BYGBlockTags.END_STONE).m_176841_(new ResourceLocation("c", "end_stones")).m_176841_(new ResourceLocation("forge", "end_stones"));
        }
        for (TagKey<Block> netherPlantTag : BYGBlockTags.NETHER_PLANT_TAGS) {
            this.m_206424_(netherPlantTag).m_206428_(BlockTags.f_13077_).m_126582_((Object)Blocks.f_50195_).m_126582_((Object)Blocks.f_50136_);
        }
        for (TagKey<Block> plantTag : BYGBlockTags.PLANT_TAGS) {
            this.m_206424_(plantTag).m_206428_(BlockTags.f_144274_);
        }
        for (TagKey<Block> plantTag : BYGBlockTags.MUSHROOM_TAGS) {
            this.m_206424_(plantTag).m_206428_(BlockTags.f_13057_).m_206428_(BlockTags.f_144274_).addTags(new TagKey[]{BlockTags.f_13061_});
        }
        for (TagKey<Block> desertPlantTag : BYGBlockTags.SAND_PLANT_TAGS) {
            this.m_206424_(desertPlantTag).m_206428_(BlockTags.f_13029_);
        }
        this.m_206424_(BYGBlockTags.GROUND_PALM_SAPLING).m_206428_(BlockTags.f_13029_).m_206428_(BlockTags.f_144274_);
        this.m_206424_(BYGBlockTags.GROUND_FAIRY_SLIPPER).m_206428_(BlockTags.f_13106_);
        this.sortTagsAlphabeticallyAndRemoveDuplicateTagEntries();
    }

    private void sortTagsAlphabeticallyAndRemoveDuplicateTagEntries() {
        for (Tag.Builder value : this.f_126543_.values()) {
            List<Tag.BuilderEntry> builderEntries = ((TagBuilderAccess)value).byg_getEntries();
            HashSet<Tag.BuilderEntry> noDuplicates = new HashSet<Tag.BuilderEntry>(builderEntries);
            builderEntries.clear();
            builderEntries.addAll(noDuplicates);
            Collections.sort(builderEntries, Comparator.comparing(builderEntry -> builderEntry.f_13338_().toString()));
        }
    }

    @SafeVarargs
    private void tag(TagKey<Block> tag, Supplier<? extends Block> ... blocks) {
        this.m_206424_(tag).m_126584_((Object[])((Block[])Arrays.stream(blocks).map(Supplier::get).toArray(Block[]::new)));
    }

    public String m_6055_() {
        return "BYG Blocks";
    }
}

