/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.mixin.common.world;

import it.unimi.dsi.fastutil.bytes.Byte2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import potionstudios.byg.common.block.sapling.GrowingPatterns;
import potionstudios.byg.common.world.LevelBiomeTracker;
import potionstudios.byg.config.BiomepediaConfig;
import potionstudios.byg.config.ConfigVersionTracker;
import potionstudios.byg.network.packet.BiomepediaActivePacket;
import potionstudios.byg.network.packet.LevelBiomeTrackerPacket;
import potionstudios.byg.network.packet.SaplingPatternsPacket;
import potionstudios.byg.server.command.UpdateConfigsCommand;
import potionstudios.byg.util.DuneCache;
import potionstudios.byg.util.ModPlatform;

@Mixin(value={ServerLevel.class})
public abstract class MixinServerLevel
extends Level
implements DuneCache {
    private Path worldPath;
    private final Long2ObjectOpenHashMap<Byte2DoubleOpenHashMap> duneDensityCache = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Byte2ObjectOpenHashMap<ResourceKey<Biome>>> duneBiomeSearchCache = new Long2ObjectOpenHashMap();
    @Nullable
    private LevelBiomeTracker bygLevelBiomeTracker = null;

    protected MixinServerLevel(WritableLevelData $$0, ResourceKey<Level> $$1, Holder<DimensionType> $$2, Supplier<ProfilerFiller> $$3, boolean $$4, boolean $$5, long $$6) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void getWorldFolder(MinecraftServer $$0, Executor $$1, LevelStorageSource.LevelStorageAccess storageAccess, ServerLevelData $$3, ResourceKey<Level> levelResourceKey, Holder $$5, ChunkProgressListener $$6, ChunkGenerator $$7, boolean $$8, long $$9, List $$10, boolean $$11, CallbackInfo ci) {
        this.worldPath = storageAccess.m_197394_(levelResourceKey);
    }

    @Shadow
    @Nonnull
    public abstract MinecraftServer m_142572_();

    @Inject(method={"addPlayer"}, at={@At(value="HEAD")})
    private void warnExperimentalBYG(ServerPlayer serverPlayer, CallbackInfo ci) {
        ModPlatform.INSTANCE.sendToClient(serverPlayer, new SaplingPatternsPacket(GrowingPatterns.getConfig()));
        ModPlatform.INSTANCE.sendToClient(serverPlayer, new BiomepediaActivePacket(BiomepediaConfig.getConfig().biomepediaEnabled()));
        if (this.bygLevelBiomeTracker == null) {
            this.bygLevelBiomeTracker = LevelBiomeTracker.fromServer(this.m_142572_());
        }
        ModPlatform.INSTANCE.sendToClient(serverPlayer, new LevelBiomeTrackerPacket(this.bygLevelBiomeTracker));
        if (ConfigVersionTracker.getConfig().configVersion() != 4) {
            if (this.m_142572_().m_7779_(serverPlayer.m_36316_())) {
                serverPlayer.m_5661_((Component)new TranslatableComponent("byg.command.updateconfig.outdatedconfigs", new Object[]{UpdateConfigsCommand.UPDATE_COMPONENT, UpdateConfigsCommand.DISMISS_UPDATE_COMPONENT}), false);
            } else {
                if (this.m_142572_().m_6982_()) {
                    serverPlayer.m_5661_((Component)new TranslatableComponent("byg.command.updateconfig.notifyserverowner.dedicated", new Object[]{new TextComponent("/byg update_configs update").m_130940_(ChatFormatting.BLUE), new TextComponent("/byg update_configs dismiss").m_130940_(ChatFormatting.BLUE)}), false);
                }
                if (this.m_142572_().m_129792_()) {
                    serverPlayer.m_5661_((Component)new TranslatableComponent("byg.command.updateconfig.notifyserverowner.singleplayer", new Object[]{new TextComponent("/byg update_configs update").m_130940_(ChatFormatting.BLUE), new TextComponent("/byg update_configs dismiss").m_130940_(ChatFormatting.BLUE)}), false);
                }
            }
        }
        if (this.m_142572_().m_129792_()) {
            // empty if block
        }
    }

    @Override
    public Long2ObjectOpenHashMap<Byte2DoubleOpenHashMap> getDensityAt() {
        return this.duneDensityCache;
    }

    @Override
    public Long2ObjectOpenHashMap<Byte2ObjectOpenHashMap<ResourceKey<Biome>>> getBiomeAt() {
        return this.duneBiomeSearchCache;
    }
}

