/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.proxy;

import java.time.LocalDateTime;
import java.time.Month;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.base.capability.CapabilityHandler;
import vazkii.quark.base.handler.BrewingHandler;
import vazkii.quark.base.handler.ContributorRewardHandler;
import vazkii.quark.base.handler.FuelHandler;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.handler.UndergroundBiomeHandler;
import vazkii.quark.base.handler.WoodSetHandler;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.config.IConfigCallback;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.recipe.DataMaintainingCampfireRecipe;
import vazkii.quark.base.recipe.DataMaintainingRecipe;
import vazkii.quark.base.recipe.DataMaintainingSmeltingRecipe;
import vazkii.quark.base.recipe.DataMaintainingSmokingRecipe;
import vazkii.quark.base.recipe.ExclusionRecipe;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.WorldGenHandler;

public class CommonProxy {
    private int lastConfigChange = -11;
    public static boolean jingleTheBells = false;
    private boolean registerDone = false;
    private boolean configGuiSaving = false;

    public void start() {
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)ExclusionRecipe.SERIALIZER);
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)DataMaintainingRecipe.SERIALIZER);
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)DataMaintainingSmeltingRecipe.SERIALIZER);
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)DataMaintainingCampfireRecipe.SERIALIZER);
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)DataMaintainingSmokingRecipe.SERIALIZER);
        QuarkSounds.start();
        ModuleLoader.INSTANCE.start();
        WorldGenHandler.start();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        this.registerListeners(bus);
        LocalDateTime now = LocalDateTime.now();
        if (now.getMonth() == Month.DECEMBER && now.getDayOfMonth() >= 16 || now.getMonth() == Month.JANUARY && now.getDayOfMonth() <= 2) {
            jingleTheBells = true;
        }
    }

    public void registerListeners(IEventBus bus) {
        bus.addListener(this::setup);
        bus.addListener(this::loadComplete);
        bus.addListener(this::configChanged);
        bus.addListener(this::registerCapabilities);
        bus.register(RegistryListener.class);
    }

    public void setup(FMLCommonSetupEvent event) {
        QuarkNetwork.setup();
        BrewingHandler.setup();
        ModuleLoader.INSTANCE.setup((ParallelDispatchEvent)event);
        this.initContributorRewards();
        WoodSetHandler.setup(event);
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        ModuleLoader.INSTANCE.loadComplete((ParallelDispatchEvent)event);
        WorldGenHandler.loadComplete(event);
        FuelHandler.addAllWoods();
        UndergroundBiomeHandler.init((ParallelDispatchEvent)event);
    }

    public void configChanged(ModConfigEvent event) {
        if (event.getConfig().getModId().equals("quark") && ClientTicker.ticksInGame - this.lastConfigChange > 10 && !this.configGuiSaving) {
            this.lastConfigChange = ClientTicker.ticksInGame;
            this.handleQuarkConfigChange();
        }
    }

    public void setConfigGuiSaving(boolean saving) {
        this.configGuiSaving = saving;
        this.lastConfigChange = ClientTicker.ticksInGame;
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        CapabilityHandler.registerCapabilities(event);
    }

    public void handleQuarkConfigChange() {
        ModuleLoader.INSTANCE.configChanged();
        EntitySpawnHandler.refresh();
    }

    public InteractionResult clientUseItem(Player player, Level level, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    protected void initContributorRewards() {
        ContributorRewardHandler.init();
    }

    public IConfigCallback getConfigCallback() {
        return new IConfigCallback.Dummy();
    }

    public static final class RegistryListener {
        private static boolean registerDone;

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerContent(RegistryEvent.Register<?> event) {
            if (registerDone) {
                return;
            }
            registerDone = true;
            ModuleLoader.INSTANCE.register();
            WoodSetHandler.register();
        }
    }
}

