/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.interaction;

import java.util.Collection;
import java.util.function.Function;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface EntityInteractionModifierHook {
    public static final EntityInteractionModifierHook EMPTY = new EntityInteractionModifierHook(){};
    public static final Function<Collection<EntityInteractionModifierHook>, EntityInteractionModifierHook> FIRST_MERGER = FirstMerger::new;
    @Deprecated
    public static final EntityInteractionModifierHook FALLBACK = new EntityInteractionModifierHook(){

        @Override
        public InteractionResult beforeEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, Entity target, InteractionHand hand, InteractionSource source) {
            if (source != InteractionSource.LEFT_CLICK) {
                return modifier.getModifier().beforeEntityUse(tool, modifier.getLevel(), player, target, hand, source.getSlot(hand));
            }
            return InteractionResult.PASS;
        }

        @Override
        public InteractionResult afterEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, LivingEntity target, InteractionHand hand, InteractionSource source) {
            if (source != InteractionSource.LEFT_CLICK) {
                return modifier.getModifier().afterEntityUse(tool, modifier.getLevel(), player, target, hand, source.getSlot(hand));
            }
            return InteractionResult.PASS;
        }
    };

    default public InteractionResult beforeEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, Entity target, InteractionHand hand, InteractionSource source) {
        return InteractionResult.PASS;
    }

    default public InteractionResult afterEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, LivingEntity target, InteractionHand hand, InteractionSource source) {
        return InteractionResult.PASS;
    }

    public record FirstMerger(Collection<EntityInteractionModifierHook> modules) implements EntityInteractionModifierHook
    {
        @Override
        public InteractionResult beforeEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, Entity target, InteractionHand hand, InteractionSource source) {
            InteractionResult result = InteractionResult.PASS;
            for (EntityInteractionModifierHook module : this.modules) {
                result = module.beforeEntityUse(tool, modifier, player, target, hand, source);
                if (!result.m_19077_()) continue;
                return result;
            }
            return result;
        }

        @Override
        public InteractionResult afterEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, LivingEntity target, InteractionHand hand, InteractionSource source) {
            InteractionResult result = InteractionResult.PASS;
            for (EntityInteractionModifierHook module : this.modules) {
                result = module.afterEntityUse(tool, modifier, player, target, hand, source);
                if (!result.m_19077_()) continue;
                return result;
            }
            return result;
        }
    }
}

