/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.interaction;

import java.util.Collection;
import java.util.function.Function;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.UseAnim;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface GeneralInteractionModifierHook {
    public static final GeneralInteractionModifierHook EMPTY = (tool, modifier, player, hand, source) -> InteractionResult.PASS;
    public static final Function<Collection<GeneralInteractionModifierHook>, GeneralInteractionModifierHook> FIRST_MERGER = FirstMerger::new;
    @Deprecated
    public static final GeneralInteractionModifierHook FALLBACK = new GeneralInteractionModifierHook(){

        @Override
        public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
            if (source != InteractionSource.LEFT_CLICK) {
                return modifier.getModifier().onToolUse(tool, modifier.getLevel(), player.f_19853_, player, hand, source.getSlot(hand));
            }
            return InteractionResult.PASS;
        }

        @Override
        public boolean onStoppedUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
            return modifier.getModifier().onStoppedUsing(tool, modifier.getLevel(), entity.f_19853_, entity, timeLeft);
        }

        @Override
        public boolean onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
            return modifier.getModifier().onFinishUsing(tool, modifier.getLevel(), entity.f_19853_, entity);
        }

        @Override
        public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
            return modifier.getModifier().getUseDuration(tool, modifier.getLevel());
        }

        @Override
        public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
            return modifier.getModifier().getUseAction(tool, modifier.getLevel());
        }
    };

    public InteractionResult onToolUse(IToolStackView var1, ModifierEntry var2, Player var3, InteractionHand var4, InteractionSource var5);

    default public boolean onStoppedUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
        return false;
    }

    default public boolean onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
        return false;
    }

    default public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 0;
    }

    default public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return UseAnim.NONE;
    }

    public record FirstMerger(Collection<GeneralInteractionModifierHook> modules) implements GeneralInteractionModifierHook
    {
        @Override
        public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
            InteractionResult result = InteractionResult.PASS;
            for (GeneralInteractionModifierHook module : this.modules) {
                result = module.onToolUse(tool, modifier, player, hand, source);
                if (!result.m_19077_()) continue;
                return result;
            }
            return result;
        }

        @Override
        public boolean onStoppedUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
            for (GeneralInteractionModifierHook module : this.modules) {
                if (!module.onStoppedUsing(tool, modifier, entity, timeLeft)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
            for (GeneralInteractionModifierHook module : this.modules) {
                if (!module.onFinishUsing(tool, modifier, entity)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
            for (GeneralInteractionModifierHook module : this.modules) {
                int duration = module.getUseDuration(tool, modifier);
                if (duration <= 0) continue;
                return duration;
            }
            return 0;
        }

        @Override
        public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
            for (GeneralInteractionModifierHook module : this.modules) {
                UseAnim anim = module.getUseAction(tool, modifier);
                if (anim == UseAnim.NONE) continue;
                return anim;
            }
            return UseAnim.NONE;
        }
    }
}

