/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling;

import java.util.Collections;
import java.util.List;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;

public record SpillingFluid(FluidIngredient ingredient, List<ISpillingEffect> effects) {
    public SpillingFluid(FluidIngredient ingredient) {
        this(ingredient, Collections.emptyList());
    }

    public boolean matches(Fluid fluid) {
        return this.ingredient.test(fluid);
    }

    public boolean hasEffects() {
        return !this.effects.isEmpty();
    }

    public FluidStack applyEffects(FluidStack fluid, int level, ToolAttackContext context) {
        int needed = this.ingredient.getAmount(fluid.getFluid());
        int maxFluid = level * needed;
        float scale = level;
        if (fluid.getAmount() < maxFluid) {
            scale = (float)fluid.getAmount() / (float)maxFluid;
        }
        for (ISpillingEffect effect : this.effects) {
            effect.applyEffects(fluid, scale, context);
        }
        fluid.shrink(maxFluid);
        return fluid;
    }
}

