/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

public abstract class AbstractModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    protected static final String KEY_MAX_LEVEL = TConstruct.makeTranslationKey("recipe", "modifier.max_level");
    protected static final String KEY_NOT_ENOUGH_SLOTS = TConstruct.makeTranslationKey("recipe", "modifier.not_enough_slots");
    protected static final String KEY_NOT_ENOUGH_SLOT = TConstruct.makeTranslationKey("recipe", "modifier.not_enough_slot");
    protected static final ValidatedResult REQUIREMENTS_ERROR = ModifierRecipeLookup.DEFAULT_ERROR;
    private final ResourceLocation id;
    protected final Ingredient toolRequirement;
    protected final int maxToolSize;
    protected final ModifierMatch requirements;
    protected final String requirementsError;
    protected final ModifierEntry result;
    private final int maxLevel;
    @Nullable
    private final SlotType.SlotCount slots;
    protected final boolean allowCrystal;
    @Nullable
    private List<ItemStack> toolInputs = null;
    private List<ItemStack> displayInputs = null;
    List<ItemStack> toolWithModifier = null;
    private ModifierEntry displayResult;

    protected AbstractModifierRecipe(ResourceLocation id, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots, boolean allowCrystal) {
        this.id = id;
        this.toolRequirement = toolRequirement;
        this.maxToolSize = maxToolSize;
        this.requirements = requirements;
        this.requirementsError = requirementsError;
        this.result = result;
        this.maxLevel = maxLevel;
        this.slots = slots;
        this.allowCrystal = allowCrystal;
        ModifierRecipeLookup.addRecipeModifier(SlotType.SlotCount.getType(slots), result.getLazyModifier());
        ModifierRecipeLookup.addRequirements(toolRequirement, result, requirements, requirementsError);
    }

    @Deprecated
    protected AbstractModifierRecipe(ResourceLocation id, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
        this(id, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots, true);
    }

    @Override
    public abstract ValidatedResult getValidatedResult(ITinkerStationContainer var1);

    @Deprecated
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Override
    public int shrinkToolSlotBy() {
        return this.maxToolSize;
    }

    List<ItemStack> getToolInputs() {
        if (this.toolInputs == null) {
            this.toolInputs = Arrays.stream(this.toolRequirement.m_43908_()).map(stack -> {
                if (stack.m_41720_() instanceof IModifiableDisplay) {
                    return ((IModifiableDisplay)stack.m_41720_()).getRenderTool();
                }
                return stack;
            }).collect(Collectors.toList());
        }
        return this.toolInputs;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        if (this.displayResult == null) {
            int min = this.requirements.getMinLevel(this.result.getId());
            this.displayResult = min > 0 ? new ModifierEntry(this.result.getId(), this.result.getLevel() + min) : this.result;
        }
        return this.displayResult;
    }

    @Override
    public List<ItemStack> getToolWithoutModifier() {
        if (this.displayInputs == null) {
            this.displayInputs = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, null)).collect(Collectors.toList());
        }
        return this.displayInputs;
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, this.result)).collect(Collectors.toList());
        }
        return this.toolWithModifier;
    }

    @Override
    public boolean hasRequirements() {
        return this.requirements != ModifierMatch.ALWAYS;
    }

    @Override
    public String getRequirementsError() {
        if (this.requirementsError.isEmpty()) {
            return ModifierRecipeLookup.DEFAULT_ERROR_KEY;
        }
        return this.requirementsError;
    }

    public static boolean matchesCrystal(ITinkerStationContainer container, ModifierEntry match) {
        boolean found = false;
        for (int i = 0; i < container.getInputCount(); ++i) {
            ItemStack stack = container.getInput(i);
            if (stack.m_41619_()) continue;
            if (found || !stack.m_150930_(TinkerModifiers.modifierCrystal.m_5456_())) {
                return false;
            }
            ModifierId modifier = ModifierCrystalItem.getModifier(stack);
            if (!match.getId().equals((Object)modifier) || stack.m_41613_() < match.getLevel()) {
                return found;
            }
            found = true;
        }
        return found;
    }

    protected boolean matchesCrystal(ITinkerStationContainer container) {
        return this.allowCrystal && AbstractModifierRecipe.matchesCrystal(container, this.result);
    }

    public static List<ModifierEntry> getModifiersIgnoringPartial(ToolStack toolStack) {
        ImmutableList.Builder finalList = ImmutableList.builder();
        ModDataNBT persistentData = toolStack.getPersistentData();
        for (ModifierEntry entry : toolStack.getModifierList()) {
            ModifierId modifier = entry.getId();
            int needed = ModifierRecipeLookup.getNeededPerLevel(modifier);
            if (needed == 0 || !persistentData.contains(modifier, 99)) {
                finalList.add((Object)entry);
                continue;
            }
            int has = persistentData.getInt(modifier);
            if (has >= needed) {
                finalList.add((Object)entry);
                continue;
            }
            if (entry.getLevel() <= 1) continue;
            finalList.add((Object)new ModifierEntry(modifier, entry.getLevel() - 1));
        }
        return finalList.build();
    }

    protected ValidatedResult validateRequirements(ToolStack tool) {
        if (this.requirements != ModifierMatch.ALWAYS && !this.requirements.test(AbstractModifierRecipe.getModifiersIgnoringPartial(tool))) {
            return this.requirementsError.isEmpty() ? REQUIREMENTS_ERROR : ValidatedResult.failure(this.requirementsError, new Object[0]);
        }
        return ValidatedResult.PASS;
    }

    protected ValidatedResult validatePrerequisites(ToolStack tool) {
        ValidatedResult requirements = this.validateRequirements(tool);
        if (requirements.hasError()) {
            return requirements;
        }
        if (this.maxLevel != 0 && tool.getUpgrades().getLevel(this.result.getId()) + this.result.getLevel() > this.maxLevel) {
            return ValidatedResult.failure(KEY_MAX_LEVEL, this.result.getModifier().getDisplayName(), this.maxLevel);
        }
        if (this.slots != null) {
            int count = this.slots.getCount();
            if (tool.getFreeSlots(this.slots.getType()) < count) {
                if (count == 1) {
                    return ValidatedResult.failure(KEY_NOT_ENOUGH_SLOT, this.slots.getType().getDisplayName());
                }
                return ValidatedResult.failure(KEY_NOT_ENOUGH_SLOTS, count, this.slots.getType().getDisplayName());
            }
        }
        return ValidatedResult.PASS;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.id + "}";
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    @Nullable
    public SlotType.SlotCount getSlots() {
        return this.slots;
    }

    public static abstract class Serializer<T extends AbstractModifierRecipe>
    extends LoggingRecipeSerializer<T> {
        public abstract T fromJson(ResourceLocation var1, JsonObject var2, Ingredient var3, int var4, ModifierMatch var5, String var6, ModifierEntry var7, int var8, @Nullable SlotType.SlotCount var9);

        public abstract T fromNetwork(ResourceLocation var1, FriendlyByteBuf var2, Ingredient var3, int var4, ModifierMatch var5, String var6, ModifierEntry var7, int var8, @Nullable SlotType.SlotCount var9);

        protected ModifierEntry readResult(JsonObject json) {
            return ModifierEntry.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        }

        public final T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient toolRequirement = Ingredient.m_43917_((JsonElement)json.get("tools"));
            int maxToolSize = GsonHelper.m_13824_((JsonObject)json, (String)"max_tool_size", (int)16);
            ModifierMatch requirements = ModifierMatch.ALWAYS;
            String requirementsError = "";
            if (json.has("requirements")) {
                JsonObject reqJson = GsonHelper.m_13930_((JsonObject)json, (String)"requirements");
                requirements = ModifierMatch.deserialize(reqJson);
                requirementsError = GsonHelper.m_13851_((JsonObject)reqJson, (String)"error", (String)"");
            }
            ModifierEntry result = this.readResult(json);
            int maxLevel = GsonHelper.m_13824_((JsonObject)json, (String)"max_level", (int)0);
            if (maxLevel < 0) {
                throw new JsonSyntaxException("max must be non-negative");
            }
            SlotType.SlotCount slots = null;
            if (json.has("slots")) {
                slots = SlotType.SlotCount.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"slots"));
            } else {
                if (json.has("upgrade_slots") && json.has("ability_slots")) {
                    throw new JsonSyntaxException("Cannot set both upgrade_slots and ability_slots");
                }
                if (json.has("upgrade_slots")) {
                    slots = new SlotType.SlotCount(SlotType.UPGRADE, JsonUtils.getIntMin(json, "upgrade_slots", 0));
                    TConstruct.LOG.warn("Using deprecated modifier recipe key upgrade_slots for recipe " + id);
                } else if (json.has("ability_slots")) {
                    slots = new SlotType.SlotCount(SlotType.ABILITY, JsonUtils.getIntMin(json, "ability_slots", 0));
                    TConstruct.LOG.warn("Using deprecated modifier recipe key ability_slots for recipe " + id);
                }
            }
            return this.fromJson(id, json, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        }

        protected final T fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient toolRequirement = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int maxToolSize = buffer.m_130242_();
            ModifierMatch requirements = ModifierMatch.read(buffer);
            String requirementsError = buffer.m_130136_(Short.MAX_VALUE);
            ModifierEntry result = ModifierEntry.read(buffer);
            int maxLevel = buffer.m_130242_();
            SlotType.SlotCount slots = SlotType.SlotCount.read(buffer);
            return this.fromNetwork(id, buffer, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, T recipe) {
            ((AbstractModifierRecipe)recipe).toolRequirement.m_43923_(buffer);
            buffer.m_130130_(((AbstractModifierRecipe)recipe).maxToolSize);
            ((AbstractModifierRecipe)recipe).requirements.write(buffer);
            buffer.m_130070_(((AbstractModifierRecipe)recipe).requirementsError);
            ((AbstractModifierRecipe)recipe).result.write(buffer);
            buffer.m_130130_(((AbstractModifierRecipe)recipe).getMaxLevel());
            SlotType.SlotCount.write(((AbstractModifierRecipe)recipe).getSlots(), buffer);
        }
    }
}

