/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.worktable;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public abstract class AbstractWorktableRecipe
implements IModifierWorktableRecipe {
    private final ResourceLocation id;
    protected final List<SizedIngredient> inputs;
    @Nullable
    protected List<ItemStack> tools;

    @Override
    public boolean matches(ITinkerableContainer inv, Level world) {
        if (!inv.getTinkerableStack().m_204117_(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        return ModifierRecipe.checkMatch(inv, this.inputs);
    }

    @Override
    public List<ModifierEntry> getModifierOptions(@Nullable ITinkerableContainer inv) {
        if (inv == null) {
            return ModifierRecipeLookup.getRecipeModifierList();
        }
        return inv.getTinkerable().getUpgrades().getModifiers();
    }

    @Override
    public void updateInputs(IToolStackView result, ITinkerableContainer.Mutable inv, boolean isServer) {
        ModifierRecipe.updateInputs(inv, this.inputs);
    }

    @Override
    public List<ItemStack> getInputTools() {
        if (this.tools == null) {
            this.tools = RegistryHelper.getTagValueStream((Registry)Registry.f_122827_, TinkerTags.Items.DURABILITY).map(IDisplayModifierRecipe.MAP_TOOL_FOR_RENDERING).toList();
        }
        return this.tools;
    }

    @Override
    public List<ItemStack> getDisplayItems(int slot) {
        if (slot < 0 || slot >= this.inputs.size()) {
            return Collections.emptyList();
        }
        return this.inputs.get(slot).getMatchingStacks();
    }

    @Override
    public int getInputCount() {
        return this.inputs.size();
    }

    public AbstractWorktableRecipe(ResourceLocation id, List<SizedIngredient> inputs) {
        this.id = id;
        this.inputs = inputs;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

