/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.worktable;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.json.predicate.modifier.TagModifierPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSetWorktableRecipe
extends AbstractWorktableRecipe {
    private static final Component NO_MATCHES = TConstruct.makeTranslation("recipe", "modifier_set_worktable.empty");
    private static final BiFunction<CompoundTag, String, ListTag> LIST_GETTER = (tag, name) -> tag.m_128437_(name, 8);
    private final Component title;
    private final Component description;
    private final ResourceLocation dataKey;
    private final IJsonPredicate<ModifierId> modifierPredicate;
    private final Predicate<ModifierEntry> entryFilter;
    private final boolean addToSet;
    private List<ModifierEntry> filteredModifiers = null;

    public ModifierSetWorktableRecipe(ResourceLocation id, ResourceLocation dataKey, List<SizedIngredient> inputs, IJsonPredicate<ModifierId> modifierPredicate, boolean addToSet) {
        super(id, inputs);
        this.dataKey = dataKey;
        this.addToSet = addToSet;
        String rootKey = Util.makeTranslationKey("recipe", dataKey) + (addToSet ? ".adding" : ".removing");
        this.title = new TranslatableComponent(rootKey + ".title");
        this.description = new TranslatableComponent(rootKey + ".description");
        this.modifierPredicate = modifierPredicate;
        this.entryFilter = entry -> modifierPredicate.matches((Object)entry.getId());
    }

    @Deprecated
    public ModifierSetWorktableRecipe(ResourceLocation id, ResourceLocation dataKey, List<SizedIngredient> inputs, TagKey<Modifier> blacklist, boolean addToSet) {
        this(id, dataKey, inputs, new TagModifierPredicate(blacklist).inverted(), addToSet);
    }

    @Override
    public Component getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null && inv.getTinkerable().getUpgrades().getModifiers().stream().noneMatch(this.entryFilter)) {
            return NO_MATCHES;
        }
        return this.description;
    }

    @Override
    public List<ModifierEntry> getModifierOptions(@Nullable ITinkerableContainer inv) {
        if (inv == null) {
            if (this.filteredModifiers == null) {
                this.filteredModifiers = ModifierRecipeLookup.getRecipeModifierList().stream().filter(this.entryFilter).toList();
            }
            return this.filteredModifiers;
        }
        ToolStack tool = inv.getTinkerable();
        Set<ModifierId> existing = ModifierSetWorktableRecipe.getModifierSet(tool.getPersistentData(), this.dataKey);
        Predicate<ModifierEntry> applicable = entry -> existing.contains((Object)entry.getId()) != this.addToSet;
        return inv.getTinkerable().getUpgrades().getModifiers().stream().filter(this.entryFilter).filter(applicable).toList();
    }

    @Override
    public RecipeResult<ToolStack> getResult(ITinkerableContainer inv, ModifierEntry modifier) {
        ListTag tagList;
        ToolStack tool = inv.getTinkerable().copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.dataKey, 9)) {
            tagList = persistentData.get(this.dataKey, LIST_GETTER);
        } else {
            tagList = new ListTag();
            persistentData.put(this.dataKey, (Tag)tagList);
        }
        String value = modifier.getId().toString();
        boolean found = false;
        for (int i = 0; i < tagList.size(); ++i) {
            if (!tagList.m_128778_(i).equals(value)) continue;
            if (!this.addToSet) {
                tagList.remove(i);
            }
            found = true;
            break;
        }
        if (!found && this.addToSet) {
            tagList.add((Object)StringTag.m_129297_((String)value));
        }
        return RecipeResult.success(tool);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierSetWorktableSerializer.get();
    }

    public static Set<ModifierId> getModifierSet(IModDataView modData, ResourceLocation key) {
        return modData.get(key, LIST_GETTER).stream().map(tag -> ModifierId.tryParse(tag.m_7916_())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ModifierSetWorktableRecipe> {
        public ModifierSetWorktableRecipe fromJson(ResourceLocation id, JsonObject json) {
            ResourceLocation dataKey = JsonHelper.getResourceLocation((JsonObject)json, (String)"data_key");
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            IJsonPredicate<ModifierId> modifierPredicate = ModifierPredicate.ALWAYS;
            if (json.has("modifier_predicate")) {
                modifierPredicate = (IJsonPredicate)ModifierPredicate.LOADER.getAndDeserialize(json, "modifier_predicate");
            } else if (json.has("blacklist")) {
                modifierPredicate = new TagModifierPredicate(ModifierManager.getTag(JsonHelper.getResourceLocation((JsonObject)json, (String)"blacklist"))).inverted();
                TConstruct.LOG.info("Recipe " + id + " is using deprecated blacklist key, this will be removed in 1.19");
            }
            boolean addToSet = GsonHelper.m_13912_((JsonObject)json, (String)"add_to_set");
            return new ModifierSetWorktableRecipe(id, dataKey, (List<SizedIngredient>)ingredients, modifierPredicate, addToSet);
        }

        @Nullable
        protected ModifierSetWorktableRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            ResourceLocation dataKey = buffer.m_130281_();
            int size = buffer.m_130242_();
            ImmutableList.Builder ingredients = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                ingredients.add((Object)SizedIngredient.read((FriendlyByteBuf)buffer));
            }
            IJsonPredicate modifierPredicate = (IJsonPredicate)ModifierPredicate.LOADER.fromNetwork(buffer);
            boolean addToSet = buffer.readBoolean();
            return new ModifierSetWorktableRecipe(id, dataKey, (List<SizedIngredient>)ingredients.build(), (IJsonPredicate<ModifierId>)modifierPredicate, addToSet);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, ModifierSetWorktableRecipe recipe) {
            buffer.m_130085_(recipe.dataKey);
            buffer.m_130130_(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            ModifierPredicate.LOADER.toNetwork(recipe.modifierPredicate, buffer);
            buffer.writeBoolean(recipe.addToSet);
        }
    }
}

