/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.weapon;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.weapon.IWeaponAttack;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.upgrades.melee.SweepingEdgeModifier;

public class SweepWeaponAttack
implements IWeaponAttack {
    public static final Loader LOADER = new Loader();
    @VisibleForTesting
    private final float range;

    @Override
    public boolean dealDamage(IToolStackView tool, ToolAttackContext context, float damage) {
        boolean hit = ToolAttackUtil.dealDefaultDamage(context.getAttacker(), context.getTarget(), damage);
        LivingEntity attacker = context.getAttacker();
        if (hit && context.isFullyCharged() && !attacker.m_20142_() && !context.isCritical() && attacker.m_20096_() && attacker.f_19787_ - attacker.f_19867_ < attacker.m_6113_()) {
            double range = this.range + (float)tool.getModifierLevel(TinkerModifiers.expanded.getId());
            double rangeSq = 2.0 + range;
            rangeSq *= rangeSq;
            float sweepDamage = ((SweepingEdgeModifier)TinkerModifiers.sweeping.get()).getSweepingDamage(tool, damage);
            Entity target = context.getTarget();
            for (LivingEntity aoeTarget : attacker.f_19853_.m_45976_(LivingEntity.class, target.m_142469_().m_82377_(range, 0.25, range))) {
                ArmorStand armorStand;
                if (aoeTarget == attacker || aoeTarget == target || attacker.m_7307_((Entity)aoeTarget) || aoeTarget instanceof ArmorStand && (armorStand = (ArmorStand)aoeTarget).m_31677_() || !(attacker.m_20280_((Entity)aoeTarget) < rangeSq)) continue;
                float angle = attacker.m_146908_() * ((float)Math.PI / 180);
                aoeTarget.m_147240_((double)0.4f, (double)Mth.m_14031_((float)angle), (double)(-Mth.m_14089_((float)angle)));
                ToolAttackUtil.dealDefaultDamage(attacker, (Entity)aoeTarget, sweepDamage);
            }
            attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12317_, attacker.m_5720_(), 1.0f, 1.0f);
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                player.m_36346_();
            }
        }
        return hit;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IWeaponAttack> getLoader() {
        return LOADER;
    }

    public SweepWeaponAttack(float range) {
        this.range = range;
    }

    public float getRange() {
        return this.range;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<SweepWeaponAttack> {
        private Loader() {
        }

        public SweepWeaponAttack deserialize(JsonObject json) {
            return new SweepWeaponAttack(GsonHelper.m_13915_((JsonObject)json, (String)"range"));
        }

        public SweepWeaponAttack fromNetwork(FriendlyByteBuf buffer) {
            return new SweepWeaponAttack(buffer.readFloat());
        }

        public void serialize(SweepWeaponAttack object, JsonObject json) {
            json.addProperty("range", (Number)Float.valueOf(object.range));
        }

        public void toNetwork(SweepWeaponAttack object, FriendlyByteBuf buffer) {
            buffer.writeFloat(object.range);
        }
    }
}

