/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ModifiableItemUtil {
    private ModifiableItemUtil() {
    }

    public static Multimap<Attribute, AttributeModifier> getMeleeAttributeModifiers(IToolStackView tool, EquipmentSlot slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!tool.isBroken()) {
            if (slot == EquipmentSlot.MAINHAND) {
                StatsNBT statsNBT = tool.getStats();
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(Item.f_41374_, "tconstruct.tool.attack_damage", (double)statsNBT.get(ToolStats.ATTACK_DAMAGE).floatValue(), AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(Item.f_41375_, "tconstruct.tool.attack_speed", (double)statsNBT.get(ToolStats.ATTACK_SPEED).floatValue() - 4.0, AttributeModifier.Operation.ADDITION));
            }
            if (slot.m_20743_() == EquipmentSlot.Type.HAND) {
                BiConsumer<Attribute, AttributeModifier> attributeConsumer = (arg_0, arg_1) -> ((ImmutableMultimap.Builder)builder).put(arg_0, arg_1);
                for (ModifierEntry entry : tool.getModifierList()) {
                    entry.getModifier().addAttributes(tool, entry.getLevel(), slot, attributeConsumer);
                }
            }
        }
        return builder.build();
    }

    public static boolean shouldCauseReequip(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack == newStack) {
            return false;
        }
        if (slotChanged || oldStack.m_41720_() != newStack.m_41720_()) {
            return true;
        }
        ToolStack oldTool = ToolStack.from(oldStack);
        ToolStack newTool = ToolStack.from(newStack);
        if (!oldTool.getMaterials().equals(newTool.getMaterials())) {
            return true;
        }
        if (!oldTool.getModifierList().equals(newTool.getModifierList())) {
            return true;
        }
        Multimap attributesNew = newStack.m_41638_(EquipmentSlot.MAINHAND);
        Multimap attributesOld = oldStack.m_41638_(EquipmentSlot.MAINHAND);
        if (attributesNew.size() != attributesOld.size()) {
            return true;
        }
        for (Attribute attribute : attributesOld.keySet()) {
            if (!attributesNew.containsKey((Object)attribute)) {
                return true;
            }
            Iterator iter1 = attributesNew.get((Object)attribute).iterator();
            Iterator iter2 = attributesOld.get((Object)attribute).iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                if (((AttributeModifier)iter1.next()).equals(iter2.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static void heldInventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof LivingEntity) {
            List<ModifierEntry> modifiers;
            ToolStack tool = ToolStack.from(stack);
            if (!worldIn.f_46443_) {
                tool.ensureHasData();
            }
            if (!(modifiers = tool.getModifierList()).isEmpty()) {
                LivingEntity living = (LivingEntity)entityIn;
                boolean isHeld = isSelected || living.m_21206_() == stack;
                for (ModifierEntry entry : modifiers) {
                    entry.getModifier().onInventoryTick(tool, entry.getLevel(), worldIn, living, itemSlot, isSelected, isHeld, stack);
                }
            }
        }
    }
}

