/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.HashMap;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ToolAction;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.modifiers.hook.LootingModifierHook;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public final class ModifierUtil {
    public static final String TAG_ENCHANTMENTS = "Enchantments";
    private static final AttributeModifier FAST_USE_ITEM = new AttributeModifier("tconstruct.fast_use_item", 3.0, AttributeModifier.Operation.MULTIPLY_TOTAL);

    @Nullable
    public static ListTag applyHarvestEnchantments(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        ListTag originalEnchants = null;
        ServerPlayer player = context.getPlayer();
        if (player == null || !player.m_7500_()) {
            ItemStack pants;
            HashMap enchantments = new HashMap();
            BiConsumer<Enchantment, Integer> enchantmentConsumer = (ench, add) -> {
                if (ench != null && add != null) {
                    Integer level = (Integer)enchantments.get(ench);
                    if (level != null) {
                        add = add + level;
                    }
                    enchantments.put(ench, add);
                }
            };
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(TinkerHooks.TOOL_HARVEST_ENCHANTMENTS).applyHarvestEnchantments(tool, entry, context, enchantmentConsumer);
            }
            if (player != null && (pants = player.m_6844_(EquipmentSlot.LEGS)).m_204117_(TinkerTags.Items.LEGGINGS)) {
                ToolStack pantsTool = ToolStack.from(pants);
                for (ModifierEntry entry : pantsTool.getModifierList()) {
                    entry.getHook(TinkerHooks.LEGGINGS_HARVEST_ENCHANTMENTS).applyHarvestEnchantments(pantsTool, entry, context, enchantmentConsumer);
                }
            }
            if (!enchantments.isEmpty()) {
                originalEnchants = stack.m_41785_();
                EnchantmentHelper.m_44865_(enchantments, (ItemStack)stack);
            }
        }
        return originalEnchants;
    }

    public static void restoreEnchantments(ItemStack stack, ListTag originalTag) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            if (originalTag.isEmpty()) {
                nbt.m_128473_(TAG_ENCHANTMENTS);
            } else {
                nbt.m_128365_(TAG_ENCHANTMENTS, (Tag)originalTag);
            }
        }
    }

    public static int getLootingLevel(IToolStackView tool, LivingEntity holder, Entity target, @Nullable DamageSource damageSource) {
        if (tool.isBroken()) {
            return 0;
        }
        return LootingModifierHook.getLootingValue(TinkerHooks.TOOL_LOOTING, tool, holder, target, damageSource, 0);
    }

    public static int getLeggingsLootingLevel(LivingEntity holder, Entity target, @Nullable DamageSource damageSource, int toolLooting) {
        ToolStack pantsTool;
        ItemStack pants = holder.m_6844_(EquipmentSlot.LEGS);
        if (!pants.m_41619_() && pants.m_204117_(TinkerTags.Items.LEGGINGS) && !(pantsTool = ToolStack.from(pants)).isBroken()) {
            toolLooting = LootingModifierHook.getLootingValue(TinkerHooks.LEGGINGS_LOOTING, pantsTool, holder, target, damageSource, toolLooting);
        }
        return toolLooting;
    }

    public static void dropItem(Entity target, ItemStack stack) {
        if (!stack.m_41619_() && !target.f_19853_.f_46443_) {
            ItemEntity ent = new ItemEntity(target.f_19853_, target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), stack);
            ent.m_32060_();
            Random rand = target.f_19853_.f_46441_;
            ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            target.f_19853_.m_7967_((Entity)ent);
        }
    }

    public static int getModifierLevel(ItemStack stack, ModifierId modifier) {
        ListTag list;
        int size;
        CompoundTag nbt;
        if (!stack.m_41619_() && stack.m_204117_(TinkerTags.Items.MODIFIABLE) && !ToolDamageUtil.isBroken(stack) && (nbt = stack.m_41783_()) != null && nbt.m_128425_("tic_modifiers", 9) && (size = (list = nbt.m_128437_("tic_modifiers", 10)).size()) > 0) {
            String key = modifier.toString();
            for (int i = 0; i < size; ++i) {
                CompoundTag entry = list.m_128728_(i);
                if (!key.equals(entry.m_128461_("name"))) continue;
                return entry.m_128451_("level");
            }
        }
        return 0;
    }

    public static boolean hasUpgrades(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            CompoundTag nbt = stack.m_41783_();
            return nbt != null && !nbt.m_128437_("tic_upgrades", 10).isEmpty();
        }
        return false;
    }

    public static void addTotalArmorModifierLevel(IToolStackView tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Integer> key, int amount, boolean allowBroken) {
        if (context.getChangedSlot().m_20743_() == EquipmentSlot.Type.ARMOR && (allowBroken || !tool.isBroken())) {
            context.getTinkerData().ifPresent(data -> {
                int totalLevels = data.get(key, 0) + amount;
                if (totalLevels <= 0) {
                    data.remove(key);
                } else {
                    data.put(key, totalLevels);
                }
            });
        }
    }

    public static void addTotalArmorModifierLevel(IToolStackView tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Integer> key, int amount) {
        ModifierUtil.addTotalArmorModifierLevel(tool, context, key, amount, false);
    }

    public static void addTotalArmorModifierFloat(IToolStackView tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Float> key, float amount) {
        if (context.getChangedSlot().m_20743_() == EquipmentSlot.Type.ARMOR && !tool.isBroken()) {
            context.getTinkerData().ifPresent(data -> {
                float totalLevels = data.get(key, Float.valueOf(0.0f)).floatValue() + amount;
                if (totalLevels <= 0.005f) {
                    data.remove(key);
                } else {
                    data.put(key, Float.valueOf(totalLevels));
                }
            });
        }
    }

    public static int getTotalModifierLevel(LivingEntity living, TinkerDataCapability.TinkerDataKey<Integer> key) {
        return living.getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> (Integer)data.get(key)).orElse(0);
    }

    public static float getTotalModifierFloat(LivingEntity living, TinkerDataCapability.TinkerDataKey<Float> key) {
        return living.getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> (Float)data.get(key)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static boolean hasAquaAffinity(LivingEntity living) {
        return ModifierUtil.getTotalModifierLevel(living, TinkerDataKeys.AQUA_AFFINITY) > 0 || EnchantmentHelper.m_44934_((LivingEntity)living);
    }

    public static boolean checkVolatileFlag(ItemStack stack, ResourceLocation flag) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("tic_volatile_data", 10)) {
            return nbt.m_128469_("tic_volatile_data").m_128471_(flag.toString());
        }
        return false;
    }

    public static int getVolatileInt(ItemStack stack, ResourceLocation flag) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("tic_volatile_data", 10)) {
            return nbt.m_128469_("tic_volatile_data").m_128451_(flag.toString());
        }
        return 0;
    }

    public static int getPersistentInt(ItemStack stack, ResourceLocation flag, int defealtValue) {
        String flagString;
        CompoundTag persistent;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("tic_persistent_data", 10) && (persistent = nbt.m_128469_("tic_persistent_data")).m_128425_(flagString = flag.toString(), 3)) {
            return persistent.m_128451_(flagString);
        }
        return defealtValue;
    }

    public static String getPersistentString(ItemStack stack, ResourceLocation flag) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("tic_persistent_data", 10)) {
            return nbt.m_128469_("tic_persistent_data").m_128461_(flag.toString());
        }
        return "";
    }

    public static boolean canPerformAction(IToolStackView tool, ToolAction action) {
        if (!tool.isBroken()) {
            if (tool.getDefinition().getData().canPerformAction(action)) {
                return true;
            }
            for (ModifierEntry entry : tool.getModifierList()) {
                if (!entry.getModifier().canPerformAction(tool, entry.getLevel(), action)) continue;
                return true;
            }
        }
        return false;
    }

    public static void checkFastUsingItem(IToolStackView tool, LivingEntity living) {
        if (living.m_6117_() && tool.getVolatileData().getBoolean(IModifiable.FAST_USE_ITEM)) {
            AttributeInstance instance = living.m_21051_(Attributes.f_22279_);
            if (instance != null && !instance.m_22109_(FAST_USE_ITEM)) {
                instance.m_22118_(FAST_USE_ITEM);
            }
            if (living.f_19853_.f_46443_) {
                living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).set(IModifiable.FAST_USE_ITEM, 0.4f));
            }
        }
    }

    public static void finishUsingItem(LivingEntity living) {
        AttributeInstance instance = living.m_21051_(Attributes.f_22279_);
        if (instance != null) {
            instance.m_22130_(FAST_USE_ITEM);
        }
        if (living.f_19853_.f_46443_) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).remove(IModifiable.FAST_USE_ITEM));
        }
    }

    private ModifierUtil() {
    }
}

