/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jsonthings.item;

import dev.gigaherz.jsonthings.things.CompletionMode;
import dev.gigaherz.jsonthings.things.IFlexItem;
import dev.gigaherz.jsonthings.things.StackContext;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.client.IItemRenderProperties;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.client.TravelersGearModel;

public class FlexBasicArmorItem
extends ModifiableArmorItem
implements IFlexItem {
    private final Map<String, FlexEventHandler> eventHandlers = new HashMap<String, FlexEventHandler>();
    private final Set<CreativeModeTab> tabs = new HashSet<CreativeModeTab>();
    private final ResourceLocation name;
    private final boolean dyeable;
    @Nullable
    private final String golden;

    public FlexBasicArmorItem(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builderIn, ToolDefinition toolDefinition, ResourceLocation name, boolean dyeable, boolean hasGolden) {
        super(materialIn, slot, builderIn, toolDefinition);
        this.name = name;
        this.dyeable = dyeable;
        this.golden = hasGolden ? name.m_135827_() + ":textures/models/armor/" + name.m_135815_() + "_golden_" + (slot == EquipmentSlot.LEGS ? 2 : 1) + ".png" : null;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (this.golden != null && ModifierUtil.getModifierLevel(stack, TinkerModifiers.golden.getId()) > 0) {
            return this.golden;
        }
        return null;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            @Nonnull
            public Model getBaseArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                if (FlexBasicArmorItem.this.dyeable) {
                    return TravelersGearModel.getModel(itemStack, armorSlot, _default, FlexBasicArmorItem.this.name, true);
                }
                return _default;
            }
        });
    }

    public void addCreativeStack(StackContext stackContext, Iterable<CreativeModeTab> tabs) {
        for (CreativeModeTab tab : tabs) {
            this.tabs.add(tab);
        }
    }

    protected boolean m_41389_(CreativeModeTab category) {
        return this.tabs.contains(category);
    }

    public void addEventHandler(String name, FlexEventHandler flexEventHandler) {
        this.eventHandlers.put(name, flexEventHandler);
    }

    @Nullable
    public FlexEventHandler getEventHandler(String name) {
        return this.eventHandlers.get(name);
    }

    public void setUseAction(UseAnim useAnim) {
    }

    public UseAnim getUseAction() {
        return UseAnim.NONE;
    }

    public void setUseTime(int i) {
    }

    public int getUseTime() {
        return 0;
    }

    public void setUseFinishMode(CompletionMode completionMode) {
    }

    public CompletionMode getUseFinishMode() {
        return CompletionMode.USE_ITEM;
    }

    public void addAttributeModifier(@Nullable EquipmentSlot equipmentSlot, Attribute attribute, AttributeModifier attributeModifier) {
    }

    public void setLore(List<MutableComponent> list) {
    }
}

