/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.ISafeManagerReloadListener;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.client.model.DynamicTextureLoader;
import slimeknights.tconstruct.library.client.model.TinkerItemProperties;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.model.tools.ToolModel;
import slimeknights.tconstruct.library.client.modifiers.BreakableDyedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.BreakableMaterialModifierModel;
import slimeknights.tconstruct.library.client.modifiers.BreakableModifierModel;
import slimeknights.tconstruct.library.client.modifiers.FluidModifierModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.client.modifiers.NormalModifierModel;
import slimeknights.tconstruct.library.client.modifiers.TankModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.utils.HarvestTiers;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.client.ArmorModelHelper;
import slimeknights.tconstruct.tools.client.CrystalshotRenderer;
import slimeknights.tconstruct.tools.client.OverslimeModifierModel;
import slimeknights.tconstruct.tools.client.PlateArmorModel;
import slimeknights.tconstruct.tools.client.SlimelytraArmorModel;
import slimeknights.tconstruct.tools.client.SlimeskullArmorModel;
import slimeknights.tconstruct.tools.client.ToolContainerScreen;
import slimeknights.tconstruct.tools.client.particles.AxeAttackParticle;
import slimeknights.tconstruct.tools.client.particles.HammerAttackParticle;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;
import slimeknights.tconstruct.tools.logic.InteractionHandler;
import slimeknights.tconstruct.tools.modifiers.ability.armor.DoubleJumpModifier;
import slimeknights.tconstruct.tools.network.TinkerControlPacket;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ToolClientEvents
extends ClientEventBase {
    private static final KeyMapping HELMET_INTERACT = new KeyMapping(TConstruct.makeTranslationKey("key", "helmet_interact"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84851_((String)"key.keyboard.z"), "key.categories.tconstruct");
    private static final KeyMapping LEGGINGS_INTERACT = new KeyMapping(TConstruct.makeTranslationKey("key", "leggings_interact"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.m_84851_((String)"key.keyboard.i"), "key.categories.tconstruct");
    private static final ISafeManagerReloadListener MODIFIER_RELOAD_LISTENER = manager -> ModifierManager.INSTANCE.getAllValues().forEach(modifier -> modifier.clearCache(PackType.CLIENT_RESOURCES));
    private static boolean wasJumping = false;
    private static boolean wasHelmetInteracting = false;
    private static boolean wasLeggingsInteracting = false;

    @SubscribeEvent
    static void addResourceListener(RegisterClientReloadListenersEvent manager) {
        ModifierModelManager.init(manager);
        MaterialTooltipCache.init(manager);
        DynamicTextureLoader.init(manager);
        manager.registerReloadListener((PreparableReloadListener)MODIFIER_RELOAD_LISTENER);
        manager.registerReloadListener((PreparableReloadListener)PlateArmorModel.RELOAD_LISTENER);
        manager.registerReloadListener((PreparableReloadListener)SlimeskullArmorModel.RELOAD_LISTENER);
        manager.registerReloadListener((PreparableReloadListener)SlimelytraArmorModel.RELOAD_LISTENER);
        manager.registerReloadListener((PreparableReloadListener)HarvestTiers.RELOAD_LISTENER);
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)TConstruct.getResource("material"), (IModelLoader)MaterialModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)TConstruct.getResource("tool"), (IModelLoader)ToolModel.LOADER);
    }

    @SubscribeEvent
    static void registerModifierModels(ModifierModelManager.ModifierModelRegistrationEvent event) {
        event.registerModel(TConstruct.getResource("normal"), NormalModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("breakable"), BreakableModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("overslime"), OverslimeModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("fluid"), FluidModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("tank"), TankModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("breakable_material"), BreakableMaterialModifierModel.UNBAKED_INSTANCE);
        event.registerModel(TConstruct.getResource("breakable_dyed"), BreakableDyedModifierModel.UNBAKED_INSTANCE);
    }

    @SubscribeEvent
    static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)TinkerTools.indestructibleItem.get(), ItemEntityRenderer::new);
        event.registerEntityRenderer((EntityType)TinkerTools.crystalshotEntity.get(), CrystalshotRenderer::new);
    }

    @SubscribeEvent
    static void clientSetupEvent(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(ToolClientEvents::handleKeyBindings);
        ArmorModelHelper.init();
        ClientRegistry.registerKeyBinding((KeyMapping)HELMET_INTERACT);
        ClientRegistry.registerKeyBinding((KeyMapping)LEGGINGS_INTERACT);
        MenuScreens.m_96206_((MenuType)((MenuType)TinkerTools.toolContainer.get()), ToolContainerScreen::new);
        TinkerItemProperties.registerCrossbowProperties(TinkerTools.crossbow.m_5456_());
        TinkerItemProperties.registerBowProperties(TinkerTools.longbow.m_5456_());
    }

    @SubscribeEvent
    static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)TinkerTools.hammerAttackParticle.get(), HammerAttackParticle.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)TinkerTools.axeAttackParticle.get(), AxeAttackParticle.Factory::new);
    }

    @SubscribeEvent
    static void itemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        ToolModel.registerItemColors(colors, TinkerTools.pickaxe);
        ToolModel.registerItemColors(colors, TinkerTools.sledgeHammer);
        ToolModel.registerItemColors(colors, TinkerTools.veinHammer);
        ToolModel.registerItemColors(colors, TinkerTools.mattock);
        ToolModel.registerItemColors(colors, TinkerTools.pickadze);
        ToolModel.registerItemColors(colors, TinkerTools.excavator);
        ToolModel.registerItemColors(colors, TinkerTools.handAxe);
        ToolModel.registerItemColors(colors, TinkerTools.broadAxe);
        ToolModel.registerItemColors(colors, TinkerTools.kama);
        ToolModel.registerItemColors(colors, TinkerTools.scythe);
        ToolModel.registerItemColors(colors, TinkerTools.dagger);
        ToolModel.registerItemColors(colors, TinkerTools.sword);
        ToolModel.registerItemColors(colors, TinkerTools.cleaver);
        ToolModel.registerItemColors(colors, TinkerTools.longbow);
        colors.m_92689_((stack, index) -> {
            ModifierId modifier = ModifierCrystalItem.getModifier(stack);
            if (modifier != null) {
                return ResourceColorManager.getColor((String)Util.makeTranslationKey("modifier", modifier));
            }
            return -1;
        }, new ItemLike[]{TinkerModifiers.modifierCrystal.m_5456_()});
    }

    private static void handleKeyBindings(TickEvent.PlayerTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && minecraft.f_91074_ == event.player && event.phase == TickEvent.Phase.START && event.side == LogicalSide.CLIENT && !minecraft.f_91074_.m_5833_()) {
            TooltipKey key;
            TooltipKey key2;
            boolean isJumping = minecraft.f_91066_.f_92089_.m_90857_();
            if (!wasJumping && isJumping && DoubleJumpModifier.extraJump(event.player)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.DOUBLE_JUMP);
            }
            wasJumping = isJumping;
            boolean isHelmetInteracting = HELMET_INTERACT.m_90857_();
            if (!wasHelmetInteracting && isHelmetInteracting && InteractionHandler.startArmorInteract(event.player, EquipmentSlot.HEAD, key2 = SafeClientAccess.getTooltipKey())) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.getStartHelmetInteract(key2));
            }
            if (wasHelmetInteracting && !isHelmetInteracting && InteractionHandler.stopArmorInteract(event.player, EquipmentSlot.HEAD)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.STOP_HELMET_INTERACT);
            }
            boolean isLeggingsInteract = LEGGINGS_INTERACT.m_90857_();
            if (!wasLeggingsInteracting && isLeggingsInteract && InteractionHandler.startArmorInteract(event.player, EquipmentSlot.LEGS, key = SafeClientAccess.getTooltipKey())) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.getStartLeggingsInteract(key));
            }
            if (wasLeggingsInteracting && !isLeggingsInteract && InteractionHandler.stopArmorInteract(event.player, EquipmentSlot.LEGS)) {
                TinkerNetwork.getInstance().sendToServer((Object)TinkerControlPacket.STOP_LEGGINGS_INTERACT);
            }
            wasHelmetInteracting = isHelmetInteracting;
            wasLeggingsInteracting = isLeggingsInteract;
        }
    }
}

