/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableLauncherItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifiableCrossbowItem
extends ModifiableLauncherItem {
    public static final ResourceLocation KEY_CROSSBOW_AMMO = TConstruct.getResource("crossbow_ammo");
    private static final String PROJECTILE_KEY = "item.minecraft.crossbow.projectile";

    public ModifiableCrossbowItem(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    public Predicate<ItemStack> m_6442_() {
        return f_43006_;
    }

    public Predicate<ItemStack> m_6437_() {
        return f_43005_;
    }

    public int m_6615_() {
        return 8;
    }

    @Override
    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.NONE;
    }

    public boolean m_41463_(ItemStack stack) {
        return true;
    }

    private static float getRandomShotPitch(float angle, Random pRandom) {
        if (angle == 0.0f) {
            return 1.0f;
        }
        return 1.0f / (pRandom.nextFloat() * 0.5f + 1.8f) + 0.53f + angle / 10.0f;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack bow = player.m_21120_(hand);
        ToolStack tool = ToolStack.from(bow);
        if (tool.isBroken()) {
            return InteractionResultHolder.m_19100_((Object)bow);
        }
        boolean sinistral = hand == InteractionHand.MAIN_HAND && tool.getModifierLevel(TinkerModifiers.sinistral.getId()) > 0 && !player.m_21206_().m_41619_();
        ModDataNBT persistentData = tool.getPersistentData();
        CompoundTag heldAmmo = persistentData.getCompound(KEY_CROSSBOW_AMMO);
        if (heldAmmo.m_128456_()) {
            if (sinistral && player.m_6047_()) {
                return InteractionResultHolder.m_19098_((Object)bow);
            }
            if (BowAmmoModifierHook.hasAmmo(tool, bow, player, this.m_6442_())) {
                player.m_6672_(hand);
                ModifierUtil.checkFastUsingItem(tool, (LivingEntity)player);
                float drawspeed = ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.DRAW_SPEED) / 20.0f;
                player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(DRAWSPEED, Float.valueOf(drawspeed)));
                persistentData.putInt(KEY_DRAWTIME, (int)Math.ceil(1.0f / drawspeed));
                if (!level.f_46443_) {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11844_, SoundSource.PLAYERS, 0.75f, 1.0f);
                }
                return InteractionResultHolder.m_19096_((Object)bow);
            }
            return InteractionResultHolder.m_19100_((Object)bow);
        }
        if (sinistral) {
            return InteractionResultHolder.m_19098_((Object)bow);
        }
        ModifiableCrossbowItem.fireCrossbow(tool, player, hand, heldAmmo);
        return InteractionResultHolder.m_19096_((Object)bow);
    }

    public static void fireCrossbow(IToolStackView tool, Player player, InteractionHand hand, CompoundTag heldAmmo) {
        Level level = player.f_19853_;
        if (!level.f_46443_) {
            int damage = 0;
            float velocity = ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.VELOCITY);
            float inaccuracy = 3.0f * (1.0f / ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.ACCURACY) - 1.0f) * velocity;
            boolean creative = player.m_150110_().f_35937_;
            ItemStack ammo = ItemStack.m_41712_((CompoundTag)heldAmmo);
            float startAngle = ModifiableCrossbowItem.getAngleStart(ammo.m_41613_());
            int primaryIndex = ammo.m_41613_() / 2;
            for (int arrowIndex = 0; arrowIndex < ammo.m_41613_(); ++arrowIndex) {
                float speed;
                FireworkRocketEntity projectile;
                AbstractArrow arrow = null;
                if (ammo.m_150930_(Items.f_42688_)) {
                    projectile = new FireworkRocketEntity(level, ammo, (Entity)player, player.m_20185_(), player.m_20188_() - (double)0.15f, player.m_20189_(), true);
                    speed = 1.5f;
                    damage += 3;
                } else {
                    ArrowItem a;
                    Item item = ammo.m_41720_();
                    ArrowItem arrowItem = item instanceof ArrowItem ? (a = (ArrowItem)item) : (ArrowItem)Items.f_42412_;
                    arrow = arrowItem.m_6394_(level, ammo, (LivingEntity)player);
                    projectile = arrow;
                    arrow.m_36762_(true);
                    arrow.m_36740_(SoundEvents.f_11840_);
                    arrow.m_36793_(true);
                    speed = 3.0f;
                    ++damage;
                    float baseArrowDamage = (float)(arrow.m_36789_() - 2.0 + (double)tool.getStats().get(ToolStats.PROJECTILE_DAMAGE).floatValue());
                    arrow.m_36781_((double)ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.PROJECTILE_DAMAGE, baseArrowDamage));
                    if (creative) {
                        arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                }
                Vector3f targetVector = new Vector3f(player.m_20252_(1.0f));
                float angle = startAngle + (float)(10 * arrowIndex);
                targetVector.m_122251_(new Quaternion(new Vector3f(player.m_20289_(1.0f)), angle, true));
                projectile.m_6686_((double)targetVector.m_122239_(), (double)targetVector.m_122260_(), (double)targetVector.m_122269_(), velocity * speed, inaccuracy);
                ModifierNBT modifiers = tool.getModifiers();
                projectile.getCapability(EntityModifierCapability.CAPABILITY).ifPresent(cap -> cap.setModifiers(modifiers));
                NamespacedNBT projectileData = PersistentDataCapability.getOrWarn((Entity)projectile);
                for (ModifierEntry entry : modifiers.getModifiers()) {
                    entry.getHook(TinkerHooks.PROJECTILE_LAUNCH).onProjectileLaunch(tool, entry, (LivingEntity)player, (Projectile)projectile, arrow, projectileData, arrowIndex == primaryIndex);
                }
                level.m_7967_((Entity)projectile);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, ModifiableCrossbowItem.getRandomShotPitch(angle, player.m_21187_()));
            }
            tool.getPersistentData().remove(KEY_CROSSBOW_AMMO);
            ToolDamageUtil.damageAnimated(tool, damage, (LivingEntity)player, hand);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10555_.m_65462_(serverPlayer, player.m_21120_(hand));
                serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)tool.getItem()));
            }
        }
    }

    public void m_5551_(ItemStack bow, Level level, LivingEntity living, int chargeRemaining) {
        ModifierUtil.finishUsingItem(living);
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        ToolStack tool = ToolStack.from(bow);
        ModDataNBT persistentData = tool.getPersistentData();
        if (tool.isBroken() || persistentData.contains(KEY_CROSSBOW_AMMO, 10)) {
            return;
        }
        if (this.m_8105_(bow) - chargeRemaining < persistentData.getInt(KEY_DRAWTIME)) {
            return;
        }
        ItemStack ammo = BowAmmoModifierHook.findAmmo(tool, bow, player, this.m_6442_());
        if (!ammo.m_41619_()) {
            level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11841_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_5822_().nextFloat() * 0.5f + 1.0f) + 0.2f);
            if (!level.f_46443_) {
                CompoundTag ammoNBT = ammo.m_41739_(new CompoundTag());
                persistentData.put(KEY_CROSSBOW_AMMO, (Tag)ammoNBT);
                if (tool.isBroken()) {
                    ModifiableCrossbowItem.fireCrossbow(tool, player, player.m_7655_(), ammoNBT);
                }
            }
        }
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack bow, int chargeRemaining) {
        if (!level.f_46443_ && this.m_8105_(bow) - chargeRemaining == ModifierUtil.getPersistentInt(bow, KEY_DRAWTIME, 0)) {
            level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11842_, SoundSource.PLAYERS, 0.75f, 1.0f);
        }
    }

    @Override
    public List<Component> getStatInformation(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        ItemStack heldStack;
        tooltips = super.getStatInformation(tool, player, tooltips, key, tooltipFlag);
        CompoundTag heldAmmo = tool.getPersistentData().getCompound(KEY_CROSSBOW_AMMO);
        if (!heldAmmo.m_128456_() && !(heldStack = ItemStack.m_41712_((CompoundTag)heldAmmo)).m_41619_()) {
            TranslatableComponent component = new TranslatableComponent(PROJECTILE_KEY);
            int count = heldStack.m_41613_();
            if (count > 1) {
                component.m_130946_(" " + count + " ");
            } else {
                component.m_130946_(" ");
            }
            tooltips.add(component.m_7220_(heldStack.m_41611_()));
            if (tooltipFlag.m_7050_() && player != null) {
                ArrayList nestedTooltip = new ArrayList();
                heldStack.m_41720_().m_7373_(heldStack, player.f_19853_, nestedTooltip, tooltipFlag);
                for (Component nested : nestedTooltip) {
                    tooltips.add(new TextComponent("  ").m_7220_(nested).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        return tooltips;
    }
}

