/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.ranged;

import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.item.CrystalshotItem;

public class CrystalshotModifier
extends NoLevelsModifier
implements BowAmmoModifierHook {
    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.BOW_AMMO);
    }

    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    public Component getDisplayName(IToolStackView tool, int level) {
        String variant = tool.getPersistentData().getString(this.getId());
        if (!variant.isEmpty()) {
            String key = this.getTranslationKey();
            return new TranslatableComponent(this.getTranslationKey()).m_130938_(style -> style.m_131148_(ResourceColorManager.getTextColor((String)(key + "." + variant))));
        }
        return super.getDisplayName();
    }

    @Override
    public ItemStack findAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack standardAmmo, Predicate<ItemStack> ammoPredicate) {
        return CrystalshotItem.withVariant(tool.getPersistentData().getString(this.getId()), 64);
    }

    @Override
    public void shrinkAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack ammo, int needed) {
        ToolDamageUtil.damageAnimated(tool, 4 * needed, shooter, shooter.m_7655_());
    }
}

