/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurios;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class CapabilityUtils {
    public static LazyOptional<ITravelersBackpack> getCapability(Player player) {
        return player.getCapability(TravelersBackpackCapability.TRAVELERS_BACKPACK_CAPABILITY, TravelersBackpackCapability.DEFAULT_FACING);
    }

    public static void synchronise(Player player) {
        CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::synchronise);
    }

    public static void synchroniseToOthers(Player player) {
        CapabilityUtils.getCapability(player).ifPresent(i -> i.synchroniseToOthers(player));
    }

    public static boolean isWearingBackpack(Player player) {
        if (TravelersBackpack.enableCurios()) {
            return TravelersBackpackCurios.getCurioTravelersBackpack((LivingEntity)player).isPresent();
        }
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        ItemStack backpack = (ItemStack)cap.lazyMap(ITravelersBackpack::getWearable).orElse((Object)ItemStack.f_41583_);
        return cap.map(ITravelersBackpack::hasWearable).orElse(false) != false && backpack.m_41720_() instanceof TravelersBackpackItem;
    }

    public static ItemStack getWearingBackpack(Player player) {
        if (TravelersBackpack.enableCurios()) {
            return TravelersBackpackCurios.getCurioTravelersBackpackStack(player);
        }
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        ItemStack backpack = cap.map(ITravelersBackpack::getWearable).orElse(ItemStack.f_41583_);
        return CapabilityUtils.isWearingBackpack(player) ? backpack : ItemStack.f_41583_;
    }

    public static void equipBackpack(Player player, ItemStack stack) {
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        if (!cap.map(ITravelersBackpack::hasWearable).orElse(false).booleanValue()) {
            cap.ifPresent(inv -> inv.setWearable(stack));
            cap.ifPresent(inv -> inv.setContents(stack));
            player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (player.f_19853_.f_46441_.nextFloat() - player.f_19853_.f_46441_.nextFloat()) * 0.2f) * 0.7f);
            CapabilityUtils.synchronise(player);
            CapabilityUtils.synchroniseToOthers(player);
        }
    }

    @Nullable
    public static TravelersBackpackContainer getBackpackInv(Player player) {
        if (TravelersBackpack.enableCurios()) {
            return TravelersBackpackCurios.getCurioTravelersBackpackInventory(player);
        }
        ItemStack wearable = CapabilityUtils.getWearingBackpack(player);
        if (wearable.m_41720_() instanceof TravelersBackpackItem) {
            return CapabilityUtils.getCapability(player).map(ITravelersBackpack::getContainer).orElse(null);
        }
        return null;
    }
}

