/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TankScreen {
    private final int height;
    private final int width;
    private final int startX;
    private final int startY;
    private final FluidTank tank;

    public TankScreen(FluidTank tank, int x, int y, int height, int width) {
        this.startX = x;
        this.startY = y;
        this.height = height;
        this.width = width;
        this.tank = tank;
    }

    public List<Component> getTankTooltip() {
        String fluidAmount;
        FluidStack fluidStack = this.tank.getFluid();
        ArrayList<Component> tankTips = new ArrayList<Component>();
        String fluidName = !fluidStack.isEmpty() ? fluidStack.getDisplayName().getString() : I18n.m_118938_((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        String string = fluidAmount = !fluidStack.isEmpty() ? fluidStack.getAmount() + "/" + this.tank.getCapacity() : I18n.m_118938_((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidStack.isEmpty() && fluidStack.getTag() != null && fluidStack.getTag().m_128441_("Potion")) {
            fluidName = null;
            TankScreen.setPotionDescription(FluidUtils.getItemStackFromFluidStack(fluidStack), tankTips);
        }
        if (fluidName != null) {
            tankTips.add((Component)new TextComponent(fluidName));
        }
        tankTips.add((Component)new TextComponent(fluidAmount));
        return tankTips;
    }

    public static void setPotionDescription(ItemStack p_43556_, List<Component> p_43557_) {
        List list = PotionUtils.m_43547_((ItemStack)p_43556_);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            p_43557_.add((Component)new TranslatableComponent("effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance mobeffectinstance : list) {
                TranslatableComponent mutablecomponent = new TranslatableComponent(mobeffectinstance.m_19576_());
                MobEffect mobeffect = mobeffectinstance.m_19544_();
                Map map = mobeffect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), mobeffect.m_7048_(mobeffectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (mobeffectinstance.m_19564_() > 0) {
                    mutablecomponent = new TranslatableComponent("potion.withAmplifier", new Object[]{mutablecomponent, new TranslatableComponent("potion.potency." + mobeffectinstance.m_19564_())});
                }
                if (mobeffectinstance.m_19557_() > 20) {
                    mutablecomponent = new TranslatableComponent("potion.withDuration", new Object[]{mutablecomponent, MobEffectUtil.m_19581_((MobEffectInstance)mobeffectinstance, (float)1.0f)});
                }
                p_43557_.add((Component)mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            p_43557_.add(TextComponent.f_131282_);
            p_43557_.add((Component)new TranslatableComponent("potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    p_43557_.add((Component)new TranslatableComponent("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1), new TranslatableComponent(((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                p_43557_.add((Component)new TranslatableComponent("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), new TranslatableComponent(((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public void drawScreenFluidBar(PoseStack poseStack) {
        RenderUtils.renderScreenTank(poseStack, this.tank, this.startX, this.startY, this.height, this.width);
    }

    public boolean inTank(TravelersBackpackScreen screen, int mouseX, int mouseY) {
        return this.startX <= (mouseX -= screen.getGuiLeft()) && mouseX <= this.startX + this.width && this.startY <= (mouseY -= screen.getGuiTop()) && mouseY <= this.startY + this.height;
    }
}

