/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.screens.ScreenImageButton;
import com.tiviacz.travelersbackpack.client.screens.TankScreen;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import com.tiviacz.travelersbackpack.network.ServerboundAbilitySliderPacket;
import com.tiviacz.travelersbackpack.network.ServerboundEquipBackpackPacket;
import com.tiviacz.travelersbackpack.network.ServerboundMemoryPacket;
import com.tiviacz.travelersbackpack.network.ServerboundSleepingBagPacket;
import com.tiviacz.travelersbackpack.network.ServerboundSlotPacket;
import com.tiviacz.travelersbackpack.network.ServerboundSorterPacket;
import com.tiviacz.travelersbackpack.network.ServerboundSpecialActionPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackScreen
extends AbstractContainerScreen<TravelersBackpackBaseMenu>
implements MenuAccess<TravelersBackpackBaseMenu> {
    public static final ResourceLocation SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack.png");
    private static final ScreenImageButton BED_BUTTON = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton EQUIP_BUTTON = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton UNEQUIP_BUTTON = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton DISABLED_CRAFTING_BUTTON = new ScreenImageButton(225, 96, 18, 18);
    private static final ScreenImageButton ABILITY_SLIDER = new ScreenImageButton(5, 56, 18, 11);
    private static final ScreenImageButton SORT_BUTTON = new ScreenImageButton(61, -10, 14, 13);
    private static final ScreenImageButton QUICK_STACK_BUTTON = new ScreenImageButton(75, -10, 11, 13);
    private static final ScreenImageButton TRANSFER_TO_BACKPACK_BUTTON = new ScreenImageButton(86, -10, 11, 13);
    private static final ScreenImageButton TRANSFER_TO_PLAYER_BUTTON = new ScreenImageButton(97, -10, 11, 13);
    private static final ScreenImageButton MEMORY_BUTTON = new ScreenImageButton(108, -10, 14, 13);
    private final ITravelersBackpackContainer container;
    private final byte screenID;
    private final TankScreen tankLeft;
    private final TankScreen tankRight;

    public TravelersBackpackScreen(TravelersBackpackBaseMenu screenContainer, Inventory inventory, Component component) {
        super((AbstractContainerMenu)screenContainer, inventory, component);
        this.container = screenContainer.container;
        this.screenID = screenContainer.container.getScreenID();
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 248;
        this.f_97727_ = 207;
        this.tankLeft = new TankScreen(this.container.getLeftTank(), 25, 7, 100, 16);
        this.tankRight = new TankScreen(this.container.getRightTank(), 207, 7, 100, 16);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        if (!this.container.getLeftTank().isEmpty()) {
            this.tankLeft.drawScreenFluidBar(poseStack);
        }
        if (!this.container.getRightTank().isEmpty()) {
            this.tankRight.drawScreenFluidBar(poseStack);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        ArrayList<FormattedCharSequence> list;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        if (this.tankLeft.inTank(this, mouseX, mouseY)) {
            this.m_96597_(poseStack, this.tankLeft.getTankTooltip(), mouseX, mouseY);
        }
        if (this.tankRight.inTank(this, mouseX, mouseY)) {
            this.m_96597_(poseStack, this.tankRight.getTankTooltip(), mouseX, mouseY);
        }
        if (BackpackUtils.isShiftPressed()) {
            if (SORT_BUTTON.inButton(this, mouseX, mouseY, 65)) {
                list = new ArrayList<FormattedCharSequence>();
                list.add(new TranslatableComponent("screen.travelersbackpack.sort").m_7532_());
                list.add(new TranslatableComponent("screen.travelersbackpack.sort_shift").m_7532_());
                this.m_96617_(poseStack, list, mouseX, mouseY);
            }
            if (QUICK_STACK_BUTTON.inButton(this, mouseX, mouseY, 76)) {
                list = new ArrayList();
                list.add(new TranslatableComponent("screen.travelersbackpack.quick_stack").m_7532_());
                list.add(new TranslatableComponent("screen.travelersbackpack.quick_stack_shift").m_7532_());
                this.m_96617_(poseStack, list, mouseX, mouseY);
            }
            if (TRANSFER_TO_BACKPACK_BUTTON.inButton(this, mouseX, mouseY, 87)) {
                list = new ArrayList();
                list.add(new TranslatableComponent("screen.travelersbackpack.transfer_to_backpack").m_7532_());
                list.add(new TranslatableComponent("screen.travelersbackpack.transfer_to_backpack_shift").m_7532_());
                this.m_96617_(poseStack, list, mouseX, mouseY);
            }
            if (TRANSFER_TO_PLAYER_BUTTON.inButton(this, mouseX, mouseY, 98)) {
                this.m_96602_(poseStack, (Component)new TranslatableComponent("screen.travelersbackpack.transfer_to_player"), mouseX, mouseY);
            }
            if (MEMORY_BUTTON.inButton(this, mouseX, mouseY, 109)) {
                this.m_96602_(poseStack, (Component)new TranslatableComponent("screen.travelersbackpack.memory"), mouseX, mouseY);
            }
        }
        if ((this.screenID == 3 || this.screenID == 2) && BackpackAbilities.isOnList(this.screenID == 2 ? BackpackAbilities.ITEM_ABILITIES_LIST : BackpackAbilities.BLOCK_ABILITIES_LIST, this.container.getItemStack()) && ABILITY_SLIDER.inButton(this, mouseX, mouseY)) {
            if (this.container.getAbilityValue()) {
                list = new ArrayList();
                list.add(new TranslatableComponent("screen.travelersbackpack.ability_enabled").m_7532_());
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_TIMER_ABILITIES_LIST, this.container.getItemStack()) || BackpackAbilities.isOnList(BackpackAbilities.BLOCK_TIMER_ABILITIES_LIST, this.container.getItemStack())) {
                    list.add(this.container.getLastTime() == 0 ? new TranslatableComponent("screen.travelersbackpack.ability_ready").m_7532_() : new TextComponent(BackpackUtils.getConvertedTime(this.container.getLastTime())).m_7532_());
                }
                this.m_96617_(poseStack, list, mouseX, mouseY);
            } else if (!TravelersBackpackConfig.enableBackpackAbilities) {
                this.m_96602_(poseStack, (Component)new TranslatableComponent("screen.travelersbackpack.ability_disabled_config"), mouseX, mouseY);
            } else {
                this.m_96602_(poseStack, (Component)new TranslatableComponent("screen.travelersbackpack.ability_disabled"), mouseX, mouseY);
            }
        }
        if (TravelersBackpackConfig.disableCrafting && DISABLED_CRAFTING_BUTTON.inButton(this, mouseX, mouseY)) {
            this.m_96602_(poseStack, (Component)new TranslatableComponent("screen.travelersbackpack.disabled_crafting"), mouseX, mouseY);
        }
    }

    public int getX(int slot) {
        if (slot <= 7) {
            return 62 + 18 * slot;
        }
        if (slot >= 8 && slot <= 15) {
            return 62 + 18 * (slot - 8);
        }
        if (slot >= 16 && slot <= 23) {
            return 62 + 18 * (slot - 16);
        }
        if (slot >= 24 && slot <= 28) {
            return 62 + 18 * (slot - 24);
        }
        if (slot >= 29 && slot <= 33) {
            return 62 + 18 * (slot - 29);
        }
        if (slot >= 34 && slot <= 38) {
            return 62 + 18 * (slot - 34);
        }
        return 0;
    }

    public int getY(int slot) {
        if (slot <= 7) {
            return 7;
        }
        if (slot <= 15) {
            return 25;
        }
        if (slot <= 23) {
            return 43;
        }
        if (slot <= 28) {
            return 61;
        }
        if (slot <= 33) {
            return 79;
        }
        if (slot <= 38) {
            return 97;
        }
        return 0;
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SCREEN_TRAVELERS_BACKPACK);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (!this.container.getSlotManager().getUnsortableSlots().isEmpty()) {
            this.container.getSlotManager().getUnsortableSlots().forEach(i -> this.m_93228_(poseStack, this.getGuiLeft() + this.getX((int)i), this.getGuiTop() + this.getY((int)i), 78, 228, 16, 16));
        }
        if (!this.container.getSlotManager().getMemorySlots().isEmpty()) {
            this.m_93250_(100);
            this.f_96542_.f_115093_ = 100.0f;
            this.container.getSlotManager().getMemorySlots().forEach(pair -> {
                if (!this.container.getHandler().getStackInSlot(((Integer)pair.getFirst()).intValue()).m_41619_()) {
                    return;
                }
                ItemStack itemstack = (ItemStack)pair.getSecond();
                RenderSystem.m_69482_();
                this.f_96542_.m_174229_((LivingEntity)this.f_96541_.f_91074_, itemstack, this.getGuiLeft() + this.getX((Integer)pair.getFirst()), this.getGuiTop() + this.getY((Integer)pair.getFirst()), 100);
                this.drawMemoryOverlay(poseStack, this.getGuiLeft() + this.getX((Integer)pair.getFirst()), this.getGuiTop() + this.getY((Integer)pair.getFirst()));
            });
            this.f_96542_.f_115093_ = 0.0f;
            this.m_93250_(0);
        }
        if (TravelersBackpackConfig.disableCrafting) {
            DISABLED_CRAFTING_BUTTON.draw(poseStack, this, 77, 208);
        }
        if (SORT_BUTTON.inButton(this, mouseX, mouseY, 65)) {
            SORT_BUTTON.draw(poseStack, this, 134, 222);
        } else {
            SORT_BUTTON.draw(poseStack, this, 134, 208);
        }
        if (this.container.getSlotManager().isSelectorActive((byte)0)) {
            SORT_BUTTON.draw(poseStack, this, 134, 236);
        }
        if (QUICK_STACK_BUTTON.inButton(this, mouseX, mouseY, 76)) {
            QUICK_STACK_BUTTON.draw(poseStack, this, 148, 222);
        } else {
            QUICK_STACK_BUTTON.draw(poseStack, this, 148, 208);
        }
        if (TRANSFER_TO_BACKPACK_BUTTON.inButton(this, mouseX, mouseY, 87)) {
            TRANSFER_TO_BACKPACK_BUTTON.draw(poseStack, this, 159, 222);
        } else {
            TRANSFER_TO_BACKPACK_BUTTON.draw(poseStack, this, 159, 208);
        }
        if (TRANSFER_TO_PLAYER_BUTTON.inButton(this, mouseX, mouseY, 98)) {
            TRANSFER_TO_PLAYER_BUTTON.draw(poseStack, this, 170, 222);
        } else {
            TRANSFER_TO_PLAYER_BUTTON.draw(poseStack, this, 170, 208);
        }
        if (MEMORY_BUTTON.inButton(this, mouseX, mouseY, 109)) {
            MEMORY_BUTTON.draw(poseStack, this, 181, 222);
        } else {
            MEMORY_BUTTON.draw(poseStack, this, 181, 208);
        }
        if (this.container.getSlotManager().isSelectorActive((byte)1)) {
            MEMORY_BUTTON.draw(poseStack, this, 181, 236);
        }
        if (this.container.hasBlockEntity()) {
            if (BED_BUTTON.inButton(this, mouseX, mouseY)) {
                BED_BUTTON.draw(poseStack, this, 20, 227);
            } else {
                BED_BUTTON.draw(poseStack, this, 1, 227);
            }
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.container.getItemStack())) {
                if (ABILITY_SLIDER.inButton(this, mouseX, mouseY)) {
                    if (this.container.getAbilityValue()) {
                        ABILITY_SLIDER.draw(poseStack, this, 115, 208);
                    } else {
                        ABILITY_SLIDER.draw(poseStack, this, 115, 220);
                    }
                } else if (this.container.getAbilityValue()) {
                    ABILITY_SLIDER.draw(poseStack, this, 96, 208);
                } else {
                    ABILITY_SLIDER.draw(poseStack, this, 96, 220);
                }
            }
        } else {
            if (!CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.m_6262_()).inventory.f_35978_) && this.screenID == 1 && !TravelersBackpack.enableCurios()) {
                if (EQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                    EQUIP_BUTTON.draw(poseStack, this, 58, 208);
                } else {
                    EQUIP_BUTTON.draw(poseStack, this, 39, 208);
                }
            }
            if (CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.m_6262_()).inventory.f_35978_) && this.screenID == 2) {
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.container.getItemStack())) {
                    if (ABILITY_SLIDER.inButton(this, mouseX, mouseY)) {
                        if (this.container.getAbilityValue()) {
                            ABILITY_SLIDER.draw(poseStack, this, 115, 208);
                        } else {
                            ABILITY_SLIDER.draw(poseStack, this, 115, 220);
                        }
                    } else if (this.container.getAbilityValue()) {
                        ABILITY_SLIDER.draw(poseStack, this, 96, 208);
                    } else {
                        ABILITY_SLIDER.draw(poseStack, this, 96, 220);
                    }
                }
                if (!TravelersBackpack.enableCurios()) {
                    if (UNEQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                        UNEQUIP_BUTTON.draw(poseStack, this, 58, 227);
                    } else {
                        UNEQUIP_BUTTON.draw(poseStack, this, 39, 227);
                    }
                }
            }
        }
    }

    public void drawMemoryOverlay(PoseStack poseStack, int x, int y) {
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69465_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SCREEN_TRAVELERS_BACKPACK);
        this.m_93228_(poseStack, x, y, 97, 232, 16, 16);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }

    protected void m_6597_(Slot slot, int slotId, int button, ClickType type) {
        super.m_6597_(slot, slotId, button, type);
        if (slotId >= 10 && slotId <= 48 && this.container.getSlotManager().isSelectorActive((byte)0)) {
            this.container.getSlotManager().setUnsortableSlot(slotId - 10);
        }
        if (slotId >= 10 && slotId <= 48 && this.container.getSlotManager().isSelectorActive((byte)1) && (!slot.m_7993_().m_41619_() || slot.m_7993_().m_41619_() && this.container.getSlotManager().isSlot((byte)1, slotId - 10))) {
            this.container.getSlotManager().setMemorySlot(slotId - 10, slot.m_7993_());
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.container.getSlotManager().isSelectorActive((byte)0) && !SORT_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 65) || this.container.getSlotManager().isSelectorActive((byte)1) && !MEMORY_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 109)) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        if (SORT_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 65)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSorterPacket(this.container.getScreenID(), 0, BackpackUtils.isShiftPressed()));
            if (BackpackUtils.isShiftPressed()) {
                TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSlotPacket(this.container.getScreenID(), this.container.getSlotManager().isSelectorActive((byte)0), this.container.getSlotManager().getUnsortableSlots().stream().mapToInt(i -> i).toArray()));
                this.container.getSlotManager().setSelectorActive((byte)0, !this.container.getSlotManager().isSelectorActive((byte)0));
            }
            this.playUIClickSound();
            return true;
        }
        if (QUICK_STACK_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 76)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSorterPacket(this.container.getScreenID(), 1, BackpackUtils.isShiftPressed()));
            this.playUIClickSound();
            return true;
        }
        if (TRANSFER_TO_BACKPACK_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 87)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSorterPacket(this.container.getScreenID(), 2, BackpackUtils.isShiftPressed()));
            this.playUIClickSound();
            return true;
        }
        if (TRANSFER_TO_PLAYER_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 98)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSorterPacket(this.container.getScreenID(), 3, BackpackUtils.isShiftPressed()));
            this.playUIClickSound();
            return true;
        }
        if (MEMORY_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 109)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSorterPacket(this.container.getScreenID(), 4, BackpackUtils.isShiftPressed()));
            TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundMemoryPacket(this.container.getScreenID(), this.container.getSlotManager().isSelectorActive((byte)1), this.container.getSlotManager().getMemorySlots().stream().mapToInt(Pair::getFirst).toArray(), (ItemStack[])this.container.getSlotManager().getMemorySlots().stream().map(Pair::getSecond).toArray(ItemStack[]::new)));
            this.container.getSlotManager().setSelectorActive((byte)1, !this.container.getSlotManager().isSelectorActive((byte)1));
            this.playUIClickSound();
            return true;
        }
        if (!this.container.getLeftTank().isEmpty() && this.tankLeft.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSpecialActionPacket(this.container.getScreenID(), 3, 1.0));
            if (this.container.getScreenID() == 1) {
                ServerActions.emptyTank(1.0, ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_, this.container.getLevel(), this.container.getScreenID());
            }
        }
        if (!this.container.getRightTank().isEmpty() && this.tankRight.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSpecialActionPacket(this.container.getScreenID(), 3, 2.0));
            if (this.container.getScreenID() == 1) {
                ServerActions.emptyTank(2.0, ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_, this.container.getLevel(), this.container.getScreenID());
            }
        }
        if (this.container.hasBlockEntity()) {
            if (BED_BUTTON.inButton(this, (int)mouseX, (int)mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSleepingBagPacket(this.container.getPosition()));
                return true;
            }
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.container.getItemStack()) && ABILITY_SLIDER.inButton(this, (int)mouseX, (int)mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundAbilitySliderPacket(this.container.getScreenID(), !this.container.getAbilityValue()));
                this.playUIClickSound();
                return true;
            }
        }
        if (!this.container.hasBlockEntity()) {
            if (!TravelersBackpack.enableCurios()) {
                if (!CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.m_6262_()).inventory.f_35978_) && this.screenID == 1 && EQUIP_BUTTON.inButton(this, (int)mouseX, (int)mouseY)) {
                    TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundEquipBackpackPacket(true));
                    return true;
                }
                if (CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.m_6262_()).inventory.f_35978_) && this.screenID == 2 && UNEQUIP_BUTTON.inButton(this, (int)mouseX, (int)mouseY)) {
                    TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundEquipBackpackPacket(false));
                    return true;
                }
            }
            if (CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.m_6262_()).inventory.f_35978_) && this.screenID == 2 && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.container.getItemStack()) && ABILITY_SLIDER.inButton(this, (int)mouseX, (int)mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundAbilitySliderPacket(this.container.getScreenID(), !this.container.getAbilityValue()));
                this.playUIClickSound();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void playUIClickSound() {
        ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_.f_19853_.m_5594_(((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_, ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_.m_142538_(), SoundEvents.f_12490_, SoundSource.MASTER, 1.0f, 1.0f);
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (ModClientEventHandler.OPEN_INVENTORY.isActiveAndMatches(InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            LocalPlayer playerEntity = this.getMinecraft().f_91074_;
            if (playerEntity != null) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

