/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackWearable;
import com.tiviacz.travelersbackpack.commands.AccessBackpackCommand;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncCapabilityPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.command.ConfigCommand;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    private static boolean checkAbilitiesForRemoval = true;
    private static long nextBackpackCountCheck = 0L;
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 100;

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ITravelersBackpack.class);
    }

    @SubscribeEvent
    public static void playerSetSpawn(PlayerSetSpawnEvent event) {
        Level level = event.getPlayer().f_19853_;
        if (event.getNewSpawn() != null) {
            Block block = level.m_8055_(event.getNewSpawn()).m_60734_();
            if (!level.f_46443_ && block instanceof SleepingBagBlock && !TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        ItemStack stack = event.getItemStack();
        if (TravelersBackpackConfig.enableBackpackBlockWearable && (block = event.getWorld().m_8055_(event.getPos()).m_60734_()) instanceof TravelersBackpackBlock) {
            TravelersBackpackBlock block2 = (TravelersBackpackBlock)block;
            Level level = event.getWorld();
            BlockPos pos = event.getPos();
            Player player = event.getPlayer();
            if (player.m_6144_() && !CapabilityUtils.isWearingBackpack(player)) {
                TravelersBackpackBlockEntity blockEntity = (TravelersBackpackBlockEntity)level.m_7702_(pos);
                ItemStack backpack = new ItemStack((ItemLike)block2, 1);
                if (!TravelersBackpack.enableCurios()) {
                    Direction bagDirection = (Direction)level.m_8055_(pos).m_61143_((Property)TravelersBackpackBlock.FACING);
                    if (level.m_46597_(pos, Blocks.f_50016_.m_49966_())) {
                        blockEntity.transferToItemStack(backpack);
                        CapabilityUtils.equipBackpack(event.getPlayer(), backpack);
                        player.m_21011_(InteractionHand.MAIN_HAND, true);
                        if (blockEntity.isSleepingBagDeployed()) {
                            level.m_46597_(pos.m_142300_(bagDirection), Blocks.f_50016_.m_49966_());
                            level.m_46597_(pos.m_142300_(bagDirection).m_142300_(bagDirection), Blocks.f_50016_.m_49966_());
                        }
                        event.setCanceled(true);
                    }
                } else {
                    blockEntity.transferToItemStack(backpack);
                    CuriosApi.getCuriosHelper().getCurio(backpack).ifPresent(curio -> CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                        Map curios = handler.getCurios();
                        for (Map.Entry entry : curios.entrySet()) {
                            IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                                ItemStack present = stackHandler.getStackInSlot(i);
                                Set tags = CuriosApi.getCuriosHelper().getCurioTags(backpack.m_41720_());
                                String id = (String)entry.getKey();
                                if (!present.m_41619_() || !tags.contains(id) && !tags.contains(SlotTypePreset.CURIO.getIdentifier()) && (tags.isEmpty() || !id.equals(SlotTypePreset.CURIO.getIdentifier())) || !curio.canEquip(id, (LivingEntity)player)) continue;
                                Direction bagDirection = (Direction)level.m_8055_(pos).m_61143_((Property)TravelersBackpackBlock.FACING);
                                if (!level.m_46597_(pos, Blocks.f_50016_.m_49966_())) continue;
                                stackHandler.setStackInSlot(i, backpack.m_41777_());
                                player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (player.f_19853_.f_46441_.nextFloat() - player.f_19853_.f_46441_.nextFloat()) * 0.2f) * 0.7f);
                                player.m_21011_(InteractionHand.MAIN_HAND, true);
                                if (blockEntity.isSleepingBagDeployed()) {
                                    level.m_46597_(pos.m_142300_(bagDirection), Blocks.f_50016_.m_49966_());
                                    level.m_46597_(pos.m_142300_(bagDirection).m_142300_(bagDirection), Blocks.f_50016_.m_49966_());
                                }
                                event.setCanceled(true);
                            }
                        }
                    }));
                }
            }
        }
        if (event.getWorld().f_46443_ || event.getPlayer().m_6144_()) {
            return;
        }
        if (stack.m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            BlockState blockState = event.getWorld().m_8055_(event.getPos());
            if (BackpackDyeRecipe.hasColor(stack) && blockState.m_60734_() instanceof LayeredCauldronBlock && (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) > 0) {
                stack.m_41783_().m_128473_("Color");
                LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)event.getWorld(), (BlockPos)event.getPos());
                event.getWorld().m_6263_(null, (double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123342_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEnderManAngerEvent(EnderManAngerEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.pumpkinAbility(event);
        }
    }

    @SubscribeEvent
    public static void blockBlazeProjectile(ProjectileImpactEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.blazeAbility(event);
        }
    }

    @SubscribeEvent
    public static void livingChangeTarget(LivingChangeTargetEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.ghastAbility(event);
        }
    }

    @SubscribeEvent
    public static void onHit(AttackEntityEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.beeAbility(event);
        }
    }

    @SubscribeEvent
    public static void onExpPickup(PlayerXpEvent.PickupXp event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.ABILITIES.lapisAbility(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onItemEntityJoin(EntityJoinWorldEvent event) {
        ItemEntity itemEntity;
        block5: {
            block4: {
                Entity entity = event.getEntity();
                if (!(entity instanceof ItemEntity)) break block4;
                itemEntity = (ItemEntity)entity;
                if (TravelersBackpackConfig.invulnerableBackpack) break block5;
            }
            return;
        }
        if (itemEntity.m_32055_().m_41720_() instanceof TravelersBackpackItem) {
            itemEntity.m_149678_();
            itemEntity.m_20331_(true);
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            TravelersBackpackWearable travelersBackpack = new TravelersBackpackWearable(player);
            event.addCapability(TravelersBackpackCapability.ID, TravelersBackpackCapability.createProvider(travelersBackpack));
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && CapabilityUtils.isWearingBackpack(player = (Player)entity)) {
            if (TravelersBackpackConfig.enableBackpackAbilities && BackpackAbilities.creeperAbility(event)) {
                return;
            }
            if (!player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
                BackpackUtils.onPlayerDeath(player.f_19853_, player, CapabilityUtils.getWearingBackpack(player));
            }
            CapabilityUtils.synchronise((Player)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        CapabilityUtils.getCapability(oldPlayer).ifPresent(oldTravelersBackpack -> CapabilityUtils.getCapability(event.getPlayer()).ifPresent(newTravelersBackpack -> {
            newTravelersBackpack.setWearable(oldTravelersBackpack.getWearable());
            newTravelersBackpack.setContents(oldTravelersBackpack.getWearable());
        }));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityUtils.synchronise(event.getPlayer());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityUtils.synchronise(event.getPlayer());
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CapabilityUtils.synchronise(player);
        }
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof Player && !event.getTarget().f_19853_.f_46443_) {
            ServerPlayer target = (ServerPlayer)event.getTarget();
            CapabilityUtils.getCapability((Player)target).ifPresent(c -> TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new ClientboundSyncCapabilityPacket(CapabilityUtils.getWearingBackpack((Player)target).m_41739_(new CompoundTag()), target.m_142049_())));
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities && event.phase == TickEvent.Phase.END && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, CapabilityUtils.getWearingBackpack(event.player))) {
            TravelersBackpackContainer.abilityTick(event.player);
            if (!checkAbilitiesForRemoval && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, CapabilityUtils.getWearingBackpack(event.player))) {
                checkAbilitiesForRemoval = true;
            }
        }
        if (!(!checkAbilitiesForRemoval || event.phase != TickEvent.Phase.END || event.player.f_19853_.f_46443_ || CapabilityUtils.isWearingBackpack(event.player) && TravelersBackpackConfig.enableBackpackAbilities)) {
            BackpackAbilities.ABILITIES.armorAbilityRemovals(event.player);
            checkAbilitiesForRemoval = false;
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !TravelersBackpackConfig.tooManyBackpacksSlowness || nextBackpackCountCheck > event.world.m_46467_()) {
            return;
        }
        nextBackpackCountCheck = event.world.m_46467_() + 100L;
        event.world.m_6907_().forEach(player -> {
            AtomicInteger numberOfBackpacks = ForgeEventHandler.checkBackpacksForSlowness(player);
            if (numberOfBackpacks.get() == 0) {
                return;
            }
            int maxNumberOfBackpacks = TravelersBackpackConfig.maxNumberOfBackpacks;
            if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * TravelersBackpackConfig.slownessPerExcessedBackpack));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, numberOfSlownessLevels - 1, false, false));
            }
        });
    }

    public static AtomicInteger checkBackpacksForSlowness(Player player) {
        AtomicInteger atomic = new AtomicInteger(0);
        for (int i = 0; i < player.m_150109_().f_35974_.size() + 1; ++i) {
            if (i != 36) {
                if (!(((ItemStack)player.m_150109_().f_35974_.get(i)).m_41720_() instanceof TravelersBackpackItem)) continue;
                atomic.incrementAndGet();
                continue;
            }
            if (!(((ItemStack)player.m_150109_().f_35976_.get(0)).m_41720_() instanceof TravelersBackpackItem)) continue;
            atomic.incrementAndGet();
        }
        return atomic;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        new AccessBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void explosionDetonate(ExplosionEvent.Detonate event) {
        for (int i = 0; i < event.getAffectedEntities().size(); ++i) {
            ItemEntity itemEntity;
            Entity entity = (Entity)event.getAffectedEntities().get(i);
            if (!(entity instanceof ItemEntity) || !((itemEntity = (ItemEntity)entity).m_32055_().m_41720_() instanceof TravelersBackpackItem)) continue;
            event.getAffectedEntities().remove(i);
        }
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (TravelersBackpackConfig.enableLoot) {
            if (event.getName().equals((Object)new ResourceLocation("chests/abandoned_mineshaft"))) {
                event.getTable().addPool(new LootPool.Builder().name(new ResourceLocation("travelersbackpack", "chests/bat").toString()).m_79082_());
            }
            if (event.getName().equals((Object)new ResourceLocation("chests/village/village_armorer"))) {
                event.getTable().addPool(new LootPool.Builder().name(new ResourceLocation("travelersbackpack", "chests/iron_golem").toString()).m_79082_());
            }
        }
    }

    @SubscribeEvent
    public static void addVillagerTrade(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35594_) {
            ((List)event.getTrades().get(5)).add(new BackpackVillagerTrade());
        }
    }

    private static class BackpackVillagerTrade
    implements VillagerTrades.ItemListing {
        private BackpackVillagerTrade() {
        }

        @Nullable
        public MerchantOffer m_5670_(Entity entity, Random random) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, random.nextInt(64) + 48), new ItemStack((ItemLike)((Item)ModItems.VILLAGER_TRAVELERS_BACKPACK.get()).m_5456_(), 1), 1, 5, 0.5f);
        }
    }
}

