/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.ContainerUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class TravelersBackpackContainer
implements ITravelersBackpackContainer,
MenuProvider,
Nameable {
    private final ItemStackHandler inventory = this.createHandler(45);
    private final ItemStackHandler craftingInventory = this.createHandler(9);
    private final FluidTank leftTank = this.createFluidHandler(TravelersBackpackConfig.tanksCapacity);
    private final FluidTank rightTank = this.createFluidHandler(TravelersBackpackConfig.tanksCapacity);
    private final SlotManager slotManager = new SlotManager(this);
    private final Player player;
    private ItemStack stack;
    private boolean ability;
    private int lastTime;
    private final byte screenID;
    private final String INVENTORY = "Inventory";
    private final String CRAFTING_INVENTORY = "CraftingInventory";
    private final String LEFT_TANK = "LeftTank";
    private final String RIGHT_TANK = "RightTank";
    private final String COLOR = "Color";
    private final String SLEEPING_BAG_COLOR = "SleepingBagColor";
    private final String ABILITY = "Ability";
    private final String LAST_TIME = "LastTime";

    public TravelersBackpackContainer(ItemStack stack, Player player, byte screenID) {
        this.player = player;
        this.stack = stack;
        this.screenID = screenID;
        this.loadAllData(stack.m_41784_());
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public ItemStackHandler getHandler() {
        return this.inventory;
    }

    @Override
    public ItemStackHandler getCraftingGridHandler() {
        return this.craftingInventory;
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public void saveAllData(CompoundTag compound) {
        this.saveTanks(compound);
        this.saveItems(compound);
        this.saveAbility(compound);
        this.saveTime(compound);
        this.slotManager.saveUnsortableSlots(compound);
        this.slotManager.saveMemorySlots(compound);
    }

    @Override
    public void loadAllData(CompoundTag compound) {
        this.loadTanks(compound);
        this.loadItems(compound);
        this.loadAbility(compound);
        this.loadTime(compound);
        this.slotManager.loadUnsortableSlots(compound);
        this.slotManager.loadMemorySlots(compound);
    }

    @Override
    public void saveItems(CompoundTag compound) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("CraftingInventory", (Tag)this.craftingInventory.serializeNBT());
    }

    @Override
    public void loadItems(CompoundTag compound) {
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.craftingInventory.deserializeNBT(compound.m_128469_("CraftingInventory"));
    }

    @Override
    public void saveTanks(CompoundTag compound) {
        compound.m_128365_("LeftTank", (Tag)this.leftTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("RightTank", (Tag)this.rightTank.writeToNBT(new CompoundTag()));
    }

    @Override
    public void loadTanks(CompoundTag compound) {
        this.leftTank.readFromNBT(compound.m_128469_("LeftTank"));
        this.rightTank.readFromNBT(compound.m_128469_("RightTank"));
    }

    @Override
    public void saveColor(CompoundTag compound) {
    }

    @Override
    public void loadColor(CompoundTag compound) {
    }

    @Override
    public void saveSleepingBagColor(CompoundTag compound) {
    }

    @Override
    public void loadSleepingBagColor(CompoundTag compound) {
    }

    @Override
    public void saveAbility(CompoundTag compound) {
        compound.m_128379_("Ability", this.ability);
    }

    @Override
    public void loadAbility(CompoundTag compound) {
        this.ability = !compound.m_128441_("Ability") && TravelersBackpackConfig.forceAbilityEnabled || compound.m_128471_("Ability");
    }

    @Override
    public void saveTime(CompoundTag compound) {
        compound.m_128405_("LastTime", this.lastTime);
    }

    @Override
    public void loadTime(CompoundTag compound) {
        this.lastTime = compound.m_128451_("LastTime");
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 41, this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), 43, this.player);
    }

    private void sendPackets() {
        if (this.screenID == 2) {
            CapabilityUtils.synchronise(this.player);
            CapabilityUtils.synchroniseToOthers(this.player);
        }
    }

    @Override
    public boolean hasColor() {
        return this.stack.m_41784_().m_128441_("Color");
    }

    @Override
    public int getColor() {
        if (this.hasColor()) {
            return this.stack.m_41784_().m_128451_("Color");
        }
        return 0;
    }

    @Override
    public boolean hasSleepingBagColor() {
        return this.stack.m_41784_().m_128441_("SleepingBagColor");
    }

    @Override
    public int getSleepingBagColor() {
        if (this.hasSleepingBagColor()) {
            return this.stack.m_41784_().m_128451_("SleepingBagColor");
        }
        return DyeColor.RED.m_41060_();
    }

    @Override
    public boolean getAbilityValue() {
        return TravelersBackpackConfig.enableBackpackAbilities ? this.ability : false;
    }

    @Override
    public void setAbility(boolean value) {
        this.ability = value;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public boolean hasBlockEntity() {
        return false;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return false;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public ItemStack removeItem(int index, int count) {
        ItemStack stack = ContainerUtils.removeItem((IItemHandler)this.getHandler(), index, count);
        if (!stack.m_41619_()) {
            this.setDataChanged(2);
        }
        return stack;
    }

    @Override
    public Level getLevel() {
        return this.player.f_19853_;
    }

    @Override
    public BlockPos getPosition() {
        return this.player.m_142538_();
    }

    @Override
    public byte getScreenID() {
        return this.screenID;
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public void setUsingPlayer(@Nullable Player player) {
    }

    @Override
    public void setDataChanged(byte ... dataIds) {
        if (this.getLevel().f_46443_) {
            return;
        }
        for (byte data : dataIds) {
            switch (data) {
                case 0: {
                    this.stack.m_41784_().m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
                }
                case 1: {
                    this.stack.m_41784_().m_128365_("CraftingInventory", (Tag)this.craftingInventory.serializeNBT());
                }
                case 2: {
                    this.saveItems(this.stack.m_41784_());
                }
                case 3: {
                    this.saveTanks(this.stack.m_41784_());
                }
                case 4: {
                    this.saveColor(this.stack.m_41784_());
                }
                case 5: {
                    this.saveSleepingBagColor(this.stack.m_41784_());
                }
                case 6: {
                    this.saveAbility(this.stack.m_41784_());
                }
                case 7: {
                    this.saveTime(this.stack.m_41784_());
                }
                case 8: {
                    this.slotManager.saveUnsortableSlots(this.stack.m_41784_());
                    this.slotManager.saveMemorySlots(this.stack.m_41784_());
                }
                case 9: {
                    this.saveAllData(this.stack.m_41784_());
                }
            }
        }
        this.sendPackets();
    }

    @Override
    public void setChanged() {
    }

    public Component m_7755_() {
        return new TranslatableComponent("screen.travelersbackpack.item");
    }

    public Component m_5446_() {
        return new TranslatableComponent("screen.travelersbackpack.item");
    }

    public static void abilityTick(Player player) {
        if (player.m_6084_() && CapabilityUtils.isWearingBackpack(player) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, CapabilityUtils.getWearingBackpack(player))) {
            TravelersBackpackContainer container = CapabilityUtils.getBackpackInv(player);
            if (!player.f_19853_.f_46443_ && container.getLastTime() > 0) {
                container.setLastTime(container.getLastTime() - 1);
                container.setDataChanged(7);
            }
            if (container.getAbilityValue()) {
                BackpackAbilities.ABILITIES.abilityTick(CapabilityUtils.getWearingBackpack(player), player, null);
            }
        }
    }

    public static void openGUI(ServerPlayer serverPlayerEntity, ItemStack stack, byte screenID) {
        if (!serverPlayerEntity.f_19853_.f_46443_) {
            if (screenID == 1) {
                NetworkHooks.openGui((ServerPlayer)serverPlayerEntity, (MenuProvider)new TravelersBackpackContainer(stack, (Player)serverPlayerEntity, screenID), packetBuffer -> packetBuffer.writeByte((int)screenID));
            }
            if (screenID == 2) {
                NetworkHooks.openGui((ServerPlayer)serverPlayerEntity, (MenuProvider)CapabilityUtils.getBackpackInv((Player)serverPlayerEntity), packetBuffer -> packetBuffer.writeByte((int)screenID));
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory inventory, Player player) {
        return new TravelersBackpackItemMenu(windowID, inventory, this);
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                TravelersBackpackContainer.this.setDataChanged(2);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return !(stack.m_41720_() instanceof TravelersBackpackItem);
            }
        };
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TravelersBackpackContainer.this.setDataChanged(3);
            }
        };
    }
}

