/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackItemStackRenderer;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurios;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class TravelersBackpackItem
extends BlockItem {
    public TravelersBackpackItem(Block block) {
        super(block, new Item.Properties().m_41491_(Reference.TAB_TRAVELERS_BACKPACK).m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND || player.m_6047_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (!level.f_46443_) {
            TravelersBackpackContainer.openGUI((ServerPlayer)player, player.m_150109_().m_36056_(), (byte)1);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.f_46443_);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult interactionResult = this.m_40576_(new BlockPlaceContext(context));
        return !interactionResult.m_19077_() ? this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_() : interactionResult;
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        if (!context.m_7059_() || context.m_43724_() == InteractionHand.MAIN_HAND && !context.m_43723_().m_6047_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockitemusecontext = this.m_7732_(context);
        if (blockitemusecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.m_5965_(blockitemusecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.m_7429_(blockitemusecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.m_8083_();
        Level level = blockitemusecontext.m_43725_();
        Player player = blockitemusecontext.m_43723_();
        ItemStack itemstack = blockitemusecontext.m_43722_();
        BlockState blockstate1 = level.m_8055_(blockpos);
        if (blockstate1.m_60713_(blockstate.m_60734_())) {
            BlockEntity blockEntity;
            this.m_7274_(blockpos, level, player, itemstack, blockstate1);
            blockstate1.m_60734_().m_6402_(level, blockpos, blockstate1, (LivingEntity)player, itemstack);
            if (itemstack.m_41783_() != null && (blockEntity = level.m_7702_(blockpos)) instanceof TravelersBackpackBlockEntity) {
                TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)blockEntity;
                blockEntity2.loadAllData(itemstack.m_41783_());
                if (itemstack.m_41788_()) {
                    blockEntity2.setCustomName(itemstack.m_41786_());
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10591_.m_59469_(serverPlayer, blockpos, itemstack);
            }
        }
        level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
        SoundType soundtype = blockstate1.getSoundType((LevelReader)level, blockpos, (Entity)context.m_43723_());
        level.m_5594_(player, blockpos, this.getPlaceSound(blockstate1, level, blockpos, player), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (player == null || !player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(ItemStack stack) {
        return new TranslatableComponent(this.m_5671_(stack)).m_130946_(" ").m_7220_((Component)new TranslatableComponent("block.travelersbackpack.travelers_backpack"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (TravelersBackpackConfig.obtainTips) {
            if (stack.m_41720_() == ModItems.BAT_TRAVELERS_BACKPACK.get()) {
                tooltip.add((Component)new TranslatableComponent("obtain.travelersbackpack.bat").m_130940_(ChatFormatting.BLUE));
            }
            if (stack.m_41720_() == ModItems.VILLAGER_TRAVELERS_BACKPACK.get()) {
                tooltip.add((Component)new TranslatableComponent("obtain.travelersbackpack.villager").m_130940_(ChatFormatting.BLUE));
            }
            if (stack.m_41720_() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                tooltip.add((Component)new TranslatableComponent("obtain.travelersbackpack.iron_golem").m_130940_(ChatFormatting.BLUE));
            }
        }
        if (BackpackAbilities.isOnList(BackpackAbilities.ALL_ABILITIES_LIST, stack)) {
            if (BackpackUtils.isShiftPressed()) {
                tooltip.add((Component)new TranslatableComponent("ability.travelersbackpack." + this.m_5671_(stack).replaceAll("block.travelersbackpack.", "")).m_130940_(ChatFormatting.BLUE));
                if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltip.add((Component)new TranslatableComponent("ability.travelersbackpack.item_and_block"));
                } else if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltip.add((Component)new TranslatableComponent("ability.travelersbackpack.block"));
                } else if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack)) {
                    tooltip.add((Component)new TranslatableComponent("ability.travelersbackpack.item"));
                }
            } else {
                tooltip.add((Component)new TranslatableComponent("ability.travelersbackpack.hold_shift").m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public boolean m_142095_() {
        return false;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return new TravelersBackpackItemStackRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_(), () -> new TravelersBackpackBlockEntity(BlockPos.f_121853_, ((Block)ModBlocks.STANDARD_TRAVELERS_BACKPACK.get()).m_49966_()));
            }
        });
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (TravelersBackpack.enableCurios()) {
            return new ICapabilityProvider(){
                final LazyOptional<ICurio> curio = LazyOptional.of(TravelersBackpackCurios::createBackpackProvider);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            };
        }
        return null;
    }
}

