/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncCapabilityPacket {
    private final CompoundTag compound;
    private final int entityID;

    public ClientboundSyncCapabilityPacket(CompoundTag compound, int entityID) {
        this.compound = compound;
        this.entityID = entityID;
    }

    public static ClientboundSyncCapabilityPacket decode(FriendlyByteBuf buffer) {
        CompoundTag compound = buffer.m_130261_();
        int entityID = buffer.readInt();
        return new ClientboundSyncCapabilityPacket(compound, entityID);
    }

    public static void encode(ClientboundSyncCapabilityPacket message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.compound);
        buffer.writeInt(message.entityID);
    }

    public static void handle(ClientboundSyncCapabilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Player playerEntity = (Player)Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(message.entityID);
            ITravelersBackpack cap = (ITravelersBackpack)CapabilityUtils.getCapability(playerEntity).orElseThrow(() -> new RuntimeException("No player capability found!"));
            if (cap != null) {
                cap.setWearable(ItemStack.m_41712_((CompoundTag)message.compound));
                cap.setContents(ItemStack.m_41712_((CompoundTag)message.compound));
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

