/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterBlock;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterItem;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import com.yungnickyoung.minecraft.yungsapi.module.BlockModuleForge;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemModuleForge {
    public static void processEntries() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, ItemModuleForge::register);
    }

    private static void register(RegistryEvent.Register<Item> event) {
        AutoRegistrationManager.BLOCKS.stream().filter(data -> !data.processed()).forEach(data -> ItemModuleForge.registerBlockItem(data, (IForgeRegistry<Item>)event.getRegistry()));
        BlockModuleForge.EXTRA_BLOCKS.forEach(extraBlockData -> ItemModuleForge.registerExtraBlockItem(extraBlockData, (IForgeRegistry<Item>)event.getRegistry()));
        AutoRegistrationManager.ITEMS.stream().filter(data -> !data.processed()).forEach(data -> ItemModuleForge.registerItem(data, (IForgeRegistry<Item>)event.getRegistry()));
    }

    private static void registerBlockItem(AutoRegisterField data, IForgeRegistry<Item> registry) {
        AutoRegisterBlock autoRegisterBlock = (AutoRegisterBlock)data.object();
        if (autoRegisterBlock.hasItemProperties()) {
            BlockItem blockItem = new BlockItem((Block)autoRegisterBlock.get(), autoRegisterBlock.getItemProperties().get());
            blockItem.setRegistryName(data.name());
            registry.register((IForgeRegistryEntry)blockItem);
            data.markProcessed();
        }
    }

    private static void registerExtraBlockItem(BlockModuleForge.ExtraBlockData extraBlockData, IForgeRegistry<Item> registry) {
        BlockItem blockItem = new BlockItem(extraBlockData.block(), extraBlockData.itemProperties().get());
        blockItem.setRegistryName(extraBlockData.block().getRegistryName());
        registry.register((IForgeRegistryEntry)blockItem);
    }

    private static void registerItem(AutoRegisterField data, IForgeRegistry<Item> registry) {
        AutoRegisterItem autoRegisterItem = (AutoRegisterItem)data.object();
        Item item = (Item)autoRegisterItem.get();
        item.setRegistryName(data.name());
        registry.register((IForgeRegistryEntry)item);
        data.markProcessed();
    }
}

