/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.mixin.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftFeatureConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class LayeredIntersection4
extends BetterMineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 7;
    private static final int Y_AXIS_LEN = 9;
    private static final int MAIN_AXIS_LEN = 7;
    private static final int LOCAL_X_END = 6;
    private static final int LOCAL_Y_END = 8;
    private static final int LOCAL_Z_END = 6;

    public LayeredIntersection4(CompoundTag compoundTag) {
        super(BetterMineshaftStructurePieceType.LAYERED_INTERSECTION_4, compoundTag);
    }

    public LayeredIntersection4(int chainLength, Random random, BoundingBox blockBox, Direction direction, BetterMineshaftFeatureConfiguration config) {
        super(BetterMineshaftStructurePieceType.LAYERED_INTERSECTION_4, chainLength, config, blockBox);
        this.m_73519_(direction);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super.m_183620_(structurePieceSerializationContext, compoundTag);
    }

    public static BoundingBox determineBoxPosition(StructurePieceAccessor structurePieceAccessor, Random random, int x, int y, int z, Direction direction) {
        BoundingBox blockBox = new BoundingBox(x, y - 3, z, x, y - 3 + 9 - 1, z);
        switch (direction) {
            default: {
                ((BoundingBoxAccessor)blockBox).setMaxX(x + 5);
                ((BoundingBoxAccessor)blockBox).setMinX(x - 1);
                ((BoundingBoxAccessor)blockBox).setMinZ(z - 6);
                break;
            }
            case SOUTH: {
                ((BoundingBoxAccessor)blockBox).setMaxX(x + 1);
                ((BoundingBoxAccessor)blockBox).setMinX(x - 5);
                ((BoundingBoxAccessor)blockBox).setMaxZ(z + 6);
                break;
            }
            case WEST: {
                ((BoundingBoxAccessor)blockBox).setMinX(x - 6);
                ((BoundingBoxAccessor)blockBox).setMaxZ(z);
                ((BoundingBoxAccessor)blockBox).setMinZ(z - 5);
                break;
            }
            case EAST: {
                ((BoundingBoxAccessor)blockBox).setMaxX(x + 6);
                ((BoundingBoxAccessor)blockBox).setMaxZ(z + 4);
                ((BoundingBoxAccessor)blockBox).setMinZ(z - 1);
            }
        }
        StructurePiece intersectingPiece = structurePieceAccessor.m_141921_(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void m_142537_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random) {
        Direction direction = this.m_73549_();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162398_() - 1, Direction.NORTH, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162401_() - 5, Direction.EAST, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162401_() - 1, Direction.WEST, this.f_73384_);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162401_() + 1, Direction.SOUTH, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162398_() + 1, Direction.EAST, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162398_() + 5, Direction.WEST, this.f_73384_);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162401_(), Direction.WEST, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() - 5, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162398_() - 1, Direction.NORTH, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162401_() + 1, Direction.SOUTH, this.f_73384_);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162398_() + 1, Direction.EAST, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() + 5, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162401_() + 1, Direction.SOUTH, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162398_() - 1, Direction.NORTH, this.f_73384_);
            }
        }
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        this.chanceReplaceNonAir(world, box, random, this.config.replacementRate, 0, 1, 0, 6, 8, 6, this.config.blockStateRandomizers.mainRandomizer);
        this.chanceReplaceNonAir(world, box, random, this.config.replacementRate, 0, 0, 0, 6, 0, 6, this.config.blockStateRandomizers.floorRandomizer);
        this.fill(world, box, 2, 1, 2, 4, 1, 4, AIR);
        this.fill(world, box, 2, 2, 1, 4, 2, 5, AIR);
        this.fill(world, box, 2, 3, 0, 4, 6, 6, AIR);
        this.fill(world, box, 0, 3, 2, 6, 6, 4, AIR);
        this.fill(world, box, 2, 2, 0, 2, 3, 1, this.config.blockStates.mainBlockState);
        this.chanceReplaceNonAir(world, box, random, 0.1f, 2, 2, 0, 2, 3, 1, this.config.blockStateRandomizers.brickRandomizer);
        this.fill(world, box, 4, 2, 0, 4, 3, 1, this.config.blockStates.mainBlockState);
        this.chanceReplaceNonAir(world, box, random, 0.1f, 4, 2, 0, 4, 3, 1, this.config.blockStateRandomizers.brickRandomizer);
        this.fill(world, box, 2, 2, 5, 2, 3, 6, this.config.blockStates.mainBlockState);
        this.chanceReplaceNonAir(world, box, random, 0.1f, 2, 2, 5, 2, 3, 6, this.config.blockStateRandomizers.brickRandomizer);
        this.fill(world, box, 4, 2, 5, 4, 3, 6, this.config.blockStates.mainBlockState);
        this.chanceReplaceNonAir(world, box, random, 0.1f, 4, 2, 5, 4, 3, 6, this.config.blockStateRandomizers.brickRandomizer);
        this.m_73434_(world, this.config.blockStates.mainBlockState, 3, 2, 0, box);
        this.m_73434_(world, this.config.blockStates.mainBlockState, 3, 1, 1, box);
        this.m_73434_(world, this.config.blockStates.mainBlockState, 3, 0, 2, box);
        this.m_73434_(world, this.config.blockStates.mainBlockState, 3, 0, 3, box);
        this.m_73434_(world, this.config.blockStates.mainBlockState, 3, 0, 4, box);
        this.m_73434_(world, this.config.blockStates.mainBlockState, 3, 1, 5, box);
        this.m_73434_(world, this.config.blockStates.mainBlockState, 3, 2, 6, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.ASCENDING_SOUTH), 3, 3, 0, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.ASCENDING_SOUTH), 3, 2, 1, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.ASCENDING_SOUTH), 3, 1, 2, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)((BlockState)Blocks.f_50030_.m_49966_().m_61124_((Property)BlockStateProperties.f_61404_, (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)), 3, 1, 3, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.ASCENDING_NORTH), 3, 1, 4, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.ASCENDING_NORTH), 3, 2, 5, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.ASCENDING_NORTH), 3, 3, 6, box);
        this.fill(world, box, 0, 3, 2, 1, 3, 4, this.config.blockStates.mainBlockState);
        this.fill(world, box, 2, 4, 2, 4, 4, 4, this.config.blockStates.mainBlockState);
        this.fill(world, box, 5, 3, 2, 6, 3, 4, this.config.blockStates.mainBlockState);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)((BlockState)Blocks.f_50030_.m_49966_().m_61124_((Property)PoweredRailBlock.f_55214_, (Comparable)RailShape.EAST_WEST)).m_61124_((Property)PoweredRailBlock.f_55215_, (Comparable)Boolean.valueOf(true)), 0, 4, 3, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.ASCENDING_EAST), 1, 4, 3, box);
        this.chanceFill(world, box, random, 0.5f, 2, 5, 3, 4, 5, 3, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.EAST_WEST));
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.ASCENDING_WEST), 5, 4, 3, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)((BlockState)Blocks.f_50030_.m_49966_().m_61124_((Property)PoweredRailBlock.f_55214_, (Comparable)RailShape.EAST_WEST)).m_61124_((Property)PoweredRailBlock.f_55215_, (Comparable)Boolean.valueOf(true)), 6, 4, 3, box);
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 6, 7, 6);
        this.addVines(world, box, random, this.config.decorationChances.vineChance, 1, 0, 1, 5, 8, 5);
    }
}

