/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.head;

import artifacts.common.config.ModConfig;
import artifacts.common.init.ModItems;
import artifacts.common.item.curio.CurioItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class DrinkingHatItem
extends CurioItem {
    public DrinkingHatItem() {
        this.addListener(LivingEntityUseItemEvent.Start.class, this::onItemUseStart);
        this.addListener(LivingEntityUseItemEvent.Finish.class, this::onItemUseFinish);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        if (((Boolean)ModConfig.client.showTooltips.get()).booleanValue() && ModConfig.server != null && !ModConfig.server.isCosmetic(this) && this != ModItems.PLASTIC_DRINKING_HAT.get()) {
            tooltip.add((Component)new TranslatableComponent(((CurioItem)((Object)ModItems.PLASTIC_DRINKING_HAT.get())).m_5524_() + ".tooltip").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, world, tooltip, flags);
    }

    private void onItemUseStart(LivingEntityUseItemEvent.Start event, LivingEntity wearer) {
        UseAnim action = event.getItem().m_41780_();
        double drinkingMultiplier = (Double)ModConfig.server.plasticDrinkingHat.drinkingDurationMultiplier.get();
        double eatingMultiplier = (Double)ModConfig.server.plasticDrinkingHat.eatingDurationMultiplier.get();
        if (action == UseAnim.DRINK) {
            event.setDuration((int)((double)event.getDuration() * drinkingMultiplier));
        } else if (action == UseAnim.EAT) {
            event.setDuration((int)((double)event.getDuration() * eatingMultiplier));
        }
    }

    private void onItemUseFinish(LivingEntityUseItemEvent.Finish event, LivingEntity wearer) {
        UseAnim action = event.getItem().m_41780_();
        double drinkingMultiplier = (Double)ModConfig.server.plasticDrinkingHat.drinkingDurationMultiplier.get();
        double eatingMultiplier = (Double)ModConfig.server.plasticDrinkingHat.eatingDurationMultiplier.get();
        if (action == UseAnim.DRINK && drinkingMultiplier != 1.0 || action == UseAnim.EAT && eatingMultiplier != 1.0) {
            this.damageEquippedStacks(wearer);
        }
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11770_, 1.0f, 1.0f);
    }
}

