/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.asm_hooks;

import com.google.common.collect.Sets;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.SkiesClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;

public class BossHealthOverlayHooks {
    private static final Set<BossEvent.BossBarColor> COLORED_INFO_FRAMES = Sets.newHashSet((Object[])new BossEvent.BossBarColor[]{BossEvent.BossBarColor.PURPLE, BossEvent.BossBarColor.RED, BossEvent.BossBarColor.GREEN, BossEvent.BossBarColor.PINK});
    private static final ResourceLocation BOSSBAR_FRAMES = BlueSkies.locate("textures/gui/bossbar_frames.png");

    public static void render(Minecraft minecraft, Map<UUID, LerpingBossEvent> events, PoseStack matrix) {
        if (!events.isEmpty()) {
            int i = minecraft.m_91268_().m_85445_();
            int j = 12;
            for (LerpingBossEvent clientbossinfo : events.values()) {
                int k = i / 2 - 91;
                if (BossHealthOverlayHooks.shouldDisplayFrame(clientbossinfo)) {
                    SkiesClientUtil.bind(BOSSBAR_FRAMES, false);
                    GuiComponent.m_93133_((PoseStack)matrix, (int)(k - 7), (int)(j - 2), (float)-4.0f, (float)(BossHealthOverlayHooks.offsetForEntity(clientbossinfo) * 9), (int)192, (int)9, (int)256, (int)256);
                }
                Objects.requireNonNull(minecraft.f_91062_);
                if ((j += 10 + 9) < minecraft.m_91268_().m_85446_() / 3) continue;
                break;
            }
        }
    }

    private static boolean shouldDisplayFrame(LerpingBossEvent info) {
        return info.m_18861_().getString().contains("\u2b50") && COLORED_INFO_FRAMES.contains(info.m_18862_());
    }

    private static int offsetForEntity(LerpingBossEvent info) {
        if (info.m_18862_() == BossEvent.BossBarColor.RED) {
            return 1;
        }
        if (info.m_18862_() == BossEvent.BossBarColor.GREEN) {
            return 2;
        }
        if (info.m_18862_() == BossEvent.BossBarColor.PINK) {
            return 3;
        }
        return 0;
    }
}

