/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.models.entities.hostile.boss;

import com.legacy.blue_skies.client.SkiesClientUtil;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import java.util.List;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class StarlitCrusherModel<T extends StarlitCrusherEntity>
extends ListModel<T> {
    protected final ModelPart leftHindLeg;
    protected final ModelPart rightHindLeg;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart leftFrontLeg;
    protected final ModelPart dummyPoint;
    protected final ModelPart body;
    protected final ModelPart leftBranch;
    protected final ModelPart rightBranch;
    protected final ModelPart backBranch;
    protected final ModelPart leaves;
    protected final ModelPart leafCross1;
    protected final ModelPart leafCross2;
    protected final ModelPart rightArm;
    protected final ModelPart rightArmLayer;
    protected final ModelPart hammer;
    protected final ModelPart hammerLayer;
    protected final ModelPart head;
    protected final ModelPart headLayer;
    private float smashWave = 0.0f;

    public StarlitCrusherModel(ModelPart model) {
        this.dummyPoint = model.m_171324_("dummy");
        this.body = this.dummyPoint.m_171324_("body");
        this.leaves = this.body.m_171324_("leaves");
        this.leafCross1 = this.leaves.m_171324_("leaf_cross_1");
        this.leafCross2 = this.leaves.m_171324_("leaf_cross_2");
        this.head = this.body.m_171324_("head");
        this.headLayer = this.head.m_171324_("head_layer");
        this.rightBranch = this.body.m_171324_("right_branch");
        this.leftBranch = this.body.m_171324_("left_branch");
        this.backBranch = this.body.m_171324_("back_branch");
        this.rightArm = this.body.m_171324_("right_arm");
        this.rightArmLayer = this.rightArm.m_171324_("right_arm_layer");
        this.hammer = this.rightArm.m_171324_("hammer");
        this.hammerLayer = this.hammer.m_171324_("hammer_layer");
        this.rightFrontLeg = this.dummyPoint.m_171324_("right_front_leg");
        this.leftFrontLeg = this.dummyPoint.m_171324_("left_front_leg");
        this.rightHindLeg = this.dummyPoint.m_171324_("right_hind_leg");
        this.leftHindLeg = this.dummyPoint.m_171324_("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        CubeDeformation size = new CubeDeformation(0.5f);
        PartDefinition dummy = root.m_171599_("dummy", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -5.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = dummy.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 53).m_171481_(-9.0f, -28.0f, -9.0f, 18.0f, 29.0f, 18.0f), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition leaves = body.m_171599_("leaves", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-19.0f, -17.0f, -19.0f, 38.0f, 16.0f, 37.0f), PartPose.m_171419_((float)0.0f, (float)-25.0f, (float)0.0f));
        leaves.m_171599_("leaf_cross_1", CubeListBuilder.m_171558_().m_171514_(72, 73).m_171481_(-22.0f, -11.0f, 0.0f, 44.0f, 11.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        leaves.m_171599_("leaf_cross_2", CubeListBuilder.m_171558_().m_171514_(72, 73).m_171481_(-22.0f, -11.0f, 0.0f, 44.0f, 11.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -5.0f, -7.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)-9.0f));
        head.m_171599_("head_layer", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-4.0f, -5.0f, -7.0f, 8.0f, 10.0f, 8.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("right_branch", CubeListBuilder.m_171558_().m_171514_(74, 53).m_171481_(-2.5f, -12.0f, -3.0f, 4.0f, 14.0f, 6.0f), PartPose.m_171423_((float)8.5f, (float)-20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6981f));
        body.m_171599_("left_branch", CubeListBuilder.m_171558_().m_171514_(74, 53).m_171480_().m_171481_(-1.5f, -12.0f, -3.0f, 4.0f, 14.0f, 6.0f), PartPose.m_171423_((float)-8.5f, (float)-20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6981f));
        body.m_171599_("back_branch", CubeListBuilder.m_171558_().m_171514_(54, 53).m_171481_(-2.5f, -12.0f, -3.0f, 6.0f, 14.0f, 4.0f), PartPose.m_171423_((float)-0.5f, (float)-20.0f, (float)9.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(110, 118).m_171481_(-16.0f, -2.0f, -2.75f, 18.0f, 5.0f, 5.0f), PartPose.m_171419_((float)-9.0f, (float)-11.0f, (float)0.25f));
        rightArm.m_171599_("right_arm_layer", CubeListBuilder.m_171558_().m_171514_(109, 108).m_171488_(-16.0f, -2.0f, -2.75f, 18.0f, 5.0f, 5.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hammer = rightArm.m_171599_("hammer", CubeListBuilder.m_171558_().m_171514_(0, 100).m_171481_(-10.0f, -4.5f, -9.0f, 10.0f, 9.0f, 17.0f), PartPose.m_171419_((float)-16.0f, (float)0.5f, (float)0.0f));
        hammer.m_171599_("hammer_layer", CubeListBuilder.m_171558_().m_171514_(55, 100).m_171488_(-10.0f, -4.5f, -9.0f, 10.0f, 9.0f, 17.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        dummy.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(136, 87).m_171480_().m_171481_(-3.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)-9.0f, (float)14.0f, (float)-9.0f));
        dummy.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(136, 87).m_171481_(-3.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)9.0f, (float)14.0f, (float)-9.0f));
        dummy.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(136, 87).m_171480_().m_171481_(-3.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)-9.0f, (float)14.0f, (float)9.0f));
        dummy.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(136, 87).m_171481_(-3.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)9.0f, (float)14.0f, (float)9.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)160, (int)128);
    }

    public Iterable<ModelPart> m_6195_() {
        return List.of(this.dummyPoint);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float netHeadYaw, float headPitch) {
        EntAnimations anims = EntAnimations.INSTANCE;
        boolean dying = ((StarlitCrusherEntity)entityIn).getDeathTicks() > 0;
        boolean rooted = ((StarlitCrusherEntity)entityIn).isRooted();
        boolean stunned = ((StarlitCrusherEntity)entityIn).isStunned();
        StarlitCrusherEntity.EntLegPosition legAnim = StarlitCrusherEntity.EntLegPosition.getEntPosition(entityIn);
        switch (legAnim) {
            case NONE: {
                anims.defaultLegAnimations(this, limbSwing, limbSwingAmount);
                this.leftHindLeg.f_104204_ = 0.0f;
                this.rightHindLeg.f_104204_ = 0.0f;
                this.rightFrontLeg.f_104204_ = 0.0f;
                this.leftFrontLeg.f_104204_ = 0.0f;
                this.leftHindLeg.f_104205_ = 0.0f;
                this.rightHindLeg.f_104205_ = 0.0f;
                this.rightFrontLeg.f_104205_ = 0.0f;
                this.leftFrontLeg.f_104205_ = 0.0f;
                break;
            }
            case DYING: {
                float x = -0.5f;
                float z = -0.5f;
                if (this.leftHindLeg.f_104203_ > x) {
                    this.leftHindLeg.f_104203_ -= 0.01f;
                }
                if (this.rightHindLeg.f_104203_ > x) {
                    this.rightHindLeg.f_104203_ -= 0.01f;
                }
                if (this.rightFrontLeg.f_104203_ < -x) {
                    this.rightFrontLeg.f_104203_ += 0.01f;
                }
                if (this.leftFrontLeg.f_104203_ < -x) {
                    this.leftFrontLeg.f_104203_ += 0.01f;
                }
                this.leftHindLeg.f_104204_ = 0.0f;
                this.rightHindLeg.f_104204_ = 0.0f;
                this.rightFrontLeg.f_104204_ = 0.0f;
                this.leftFrontLeg.f_104204_ = 0.0f;
                if (this.leftHindLeg.f_104205_ < -z) {
                    this.leftHindLeg.f_104205_ += 0.01f;
                }
                if (this.rightHindLeg.f_104205_ > z) {
                    this.rightHindLeg.f_104205_ -= 0.01f;
                }
                if (this.rightFrontLeg.f_104205_ > z) {
                    this.rightFrontLeg.f_104205_ -= 0.01f;
                }
                if (!(this.leftFrontLeg.f_104205_ < -z)) break;
                this.leftFrontLeg.f_104205_ += 0.01f;
                break;
            }
            case SPINNING: {
                float x = -0.5f;
                float y = 0.0f;
                float z = -0.5f;
                this.leftHindLeg.f_104203_ = x;
                this.rightHindLeg.f_104203_ = x;
                this.rightFrontLeg.f_104203_ = -x;
                this.leftFrontLeg.f_104203_ = -x;
                this.leftHindLeg.f_104204_ = -y;
                this.rightHindLeg.f_104204_ = y;
                this.rightFrontLeg.f_104204_ = -y;
                this.leftFrontLeg.f_104204_ = y;
                this.leftHindLeg.f_104205_ = -z;
                this.rightHindLeg.f_104205_ = z;
                this.rightFrontLeg.f_104205_ = z;
                this.leftFrontLeg.f_104205_ = -z;
                break;
            }
            case ROOTED: {
                this.leftHindLeg.f_104203_ = 1.0f;
                this.rightHindLeg.f_104203_ = 1.0f;
                this.rightFrontLeg.f_104203_ = -1.0f;
                this.leftFrontLeg.f_104203_ = -1.0f;
                this.leftHindLeg.f_104204_ = -0.7f;
                this.rightHindLeg.f_104204_ = 0.7f;
                this.rightFrontLeg.f_104204_ = -0.7f;
                this.leftFrontLeg.f_104204_ = 0.7f;
                this.leftHindLeg.f_104205_ = -1.2f;
                this.rightHindLeg.f_104205_ = 1.2f;
                this.rightFrontLeg.f_104205_ = 1.2f;
                this.leftFrontLeg.f_104205_ = -1.2f;
                break;
            }
            case STUNNED: {
                this.leftHindLeg.f_104203_ = 1.0f;
                this.rightHindLeg.f_104203_ = 1.0f;
                this.rightFrontLeg.f_104203_ = -1.0f;
                this.leftFrontLeg.f_104203_ = -1.0f;
                this.leftHindLeg.f_104204_ = -0.1f;
                this.rightHindLeg.f_104204_ = 0.1f;
                this.rightFrontLeg.f_104204_ = -0.1f;
                this.leftFrontLeg.f_104204_ = 0.1f;
                this.leftHindLeg.f_104205_ = -1.5f;
                this.rightHindLeg.f_104205_ = 1.5f;
                this.rightFrontLeg.f_104205_ = 1.5f;
                this.leftFrontLeg.f_104205_ = -1.5f;
            }
        }
        if (dying) {
            this.leaves.f_104204_ = Mth.m_14089_((float)(partialTicks * 3.0f)) * 0.1f;
            this.leaves.f_104203_ = -0.12f + Mth.m_14089_((float)(partialTicks * 1.5f)) * 0.1f;
            if (this.head.f_104203_ > -1.0f) {
                this.head.f_104203_ -= 0.005f;
            }
            this.head.f_104203_ = this.head.f_104203_ > -1.0f ? 0.0f - (float)((StarlitCrusherEntity)entityIn).getDeathTicks() * 0.01f : -1.0f;
            this.head.f_104204_ = Mth.m_14089_((float)(partialTicks * 1.0f)) * 0.1f;
            this.rightArm.f_104203_ = 0.0f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = this.rightArm.f_104205_ < 1.0f ? -0.65f + (float)((StarlitCrusherEntity)entityIn).getDeathTicks() * 0.023f : 1.0f;
            return;
        }
        if (rooted) {
            anims.defaultHeadAnimations(this, headPitch, netHeadYaw, (StarlitCrusherEntity)entityIn, partialTicks);
            this.dummyPoint.f_104201_ = 6.0f;
            this.body.f_104203_ = 0.0f;
            anims.hammerAnimations(this, (StarlitCrusherEntity)entityIn, limbSwingAmount, partialTicks);
            this.rightArm.f_104205_ = -0.3f;
            if (((StarlitCrusherEntity)entityIn).canShake) {
                this.leaves.f_104204_ = Mth.m_14089_((float)(partialTicks * 2.0f)) * 0.1f;
            }
        } else if (stunned) {
            this.head.f_104203_ = 0.5f + Mth.m_14089_((float)(partialTicks * 0.1f)) * 0.2f + limbSwingAmount * 0.5f;
            this.head.f_104204_ = 0.0f;
            this.headLayer.f_104203_ = Mth.m_14031_((float)(partialTicks * 0.1f)) * 3.0f * ((float)Math.PI / 180);
            this.headLayer.f_104204_ = 0.0f;
            this.headLayer.f_104205_ = Mth.m_14089_((float)(partialTicks * 0.1f)) * 2.5f * ((float)Math.PI / 180);
            this.dummyPoint.f_104201_ = 6.0f;
            this.body.f_104203_ = 0.0f;
            this.rightArm.f_104203_ = 0.0f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = -0.3f;
        } else {
            if (((StarlitCrusherEntity)entityIn).isSpinning()) {
                this.body.f_104203_ = 0.0f;
            }
            this.dummyPoint.f_104201_ = ((StarlitCrusherEntity)entityIn).isSpinning() ? -1.5f : -2.0f;
            this.rightArm.f_104207_ = true;
            anims.hammerAnimations(this, (StarlitCrusherEntity)entityIn, limbSwingAmount, partialTicks);
            anims.defaultHeadAnimations(this, headPitch, netHeadYaw, (StarlitCrusherEntity)entityIn, partialTicks);
        }
        if (!((StarlitCrusherEntity)entityIn).canShake) {
            this.leaves.f_104204_ = 0.0f;
        }
        this.leaves.f_104203_ = -0.12f + Mth.m_14089_((float)(partialTicks * 0.2f)) * 0.1f;
        this.backBranch.f_104203_ = -0.6981f + Mth.m_14089_((float)(partialTicks * 0.2f)) * 0.1f;
        this.leftBranch.f_104203_ = Mth.m_14089_((float)(partialTicks * 0.2f)) * 0.1f;
        this.rightBranch.f_104203_ = Mth.m_14089_((float)(partialTicks * 0.2f)) * 0.1f;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        if (((StarlitCrusherEntity)entityIn).attackTimer > 0) {
            this.smashWave = 0.0f;
            float h = -0.5f + 1.5f * this.triangleWave((float)((StarlitCrusherEntity)entityIn).attackTimer - partialTick, 10.0f);
            this.rightArm.f_104204_ = Math.min(0.0f, h);
            return;
        }
        if (((StarlitCrusherEntity)entityIn).smashTimer > 0) {
            float f = this.triangleWave((float)((StarlitCrusherEntity)entityIn).smashTimer - partialTick, 20.0f);
            float h = -0.5f + 1.5f * f;
            float finalX = Math.min(0.1f, f * 0.4f);
            this.rightArm.f_104204_ = -1.0f + Math.min(0.0f, h);
            this.body.f_104203_ = 0.0f;
            this.body.f_104203_ += finalX;
            this.smashWave = -finalX;
            return;
        }
        this.body.f_104203_ = 0.0f;
        this.smashWave = 0.0f;
    }

    private float triangleWave(float min, float max) {
        return (Math.abs(min % max - max * 0.5f) - max * 0.25f) / (max * 0.25f);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }

    static class EntAnimations {
        public static final EntAnimations INSTANCE = new EntAnimations();

        EntAnimations() {
        }

        public void defaultHeadAnimations(StarlitCrusherModel<?> model, float headPitch, float netHeadYaw, StarlitCrusherEntity entityIn, float partialTicks) {
            model.head.f_104205_ = 0.0f;
            model.head.f_104203_ = headPitch * ((float)Math.PI / 180) + model.smashWave;
            model.head.f_104204_ = SkiesClientUtil.lockNum(netHeadYaw * ((float)Math.PI / 180), 0.75f);
            if (model.head.f_104204_ == 4.0f) {
                model.head.f_104204_ = 0.0f;
            }
            model.headLayer.f_104203_ = Mth.m_14031_((float)(partialTicks * 0.1f)) * 3.0f * ((float)Math.PI / 180);
            model.headLayer.f_104204_ = 0.0f;
            model.headLayer.f_104205_ = Mth.m_14089_((float)(partialTicks * 0.1f)) * 2.5f * ((float)Math.PI / 180);
        }

        public void defaultLegAnimations(StarlitCrusherModel<?> model, float limbSwing, float limbSwingAmount) {
            model.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            model.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            model.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            model.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }

        public void hammerAnimations(StarlitCrusherModel<?> model, StarlitCrusherEntity entityIn, float limbSwingAmount, float ageInTicks) {
            boolean smashing;
            if (entityIn.isSpinning()) {
                model.rightArm.f_104204_ = 0.0f;
                model.rightArm.f_104203_ = 0.0f;
                model.rightArm.f_104205_ = 0.0f;
                return;
            }
            float moveResist = limbSwingAmount * 1.0f;
            boolean attacking = (float)entityIn.attackTimer > 0.0f;
            boolean bl = smashing = (float)entityIn.smashTimer > 0.0f;
            if (attacking) {
                model.rightArm.f_104203_ = 0.0f;
                model.rightArm.f_104205_ = -0.65f;
                return;
            }
            if (smashing) {
                model.rightArm.f_104203_ = 0.0f;
                model.rightArm.f_104205_ = -1.6f;
                return;
            }
            model.rightArm.f_104203_ = -Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.1f - moveResist;
            model.rightArm.f_104204_ = Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.1f + moveResist;
            model.rightArm.f_104205_ = -0.65f;
        }
    }
}

