/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities;

import com.legacy.blue_skies.registries.SkiesEntityTypes;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BossItemEntity
extends ItemEntity {
    protected static final EntityDataAccessor<Optional<UUID>> VISIBLE_PLAYER_UNIQUE_ID = SynchedEntityData.m_135353_(BossItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public BossItemEntity(EntityType<? extends ItemEntity> type, Level world) {
        super(type, world);
    }

    public BossItemEntity(Level worldIn, double x, double y, double z) {
        this(SkiesEntityTypes.BOSS_ITEM, worldIn);
        this.m_6034_(x, y, z);
        this.m_146922_(this.f_19796_.nextFloat() * 360.0f);
        this.m_20334_(this.f_19796_.nextDouble() * 0.2 - 0.1, 0.2, this.f_19796_.nextDouble() * 0.2 - 0.1);
        this.m_20331_(true);
    }

    public BossItemEntity(Level worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn, x, y, z);
        this.m_32045_(stack);
        this.lifespan = stack.m_41720_() == null ? 6000 : stack.getEntityLifespan(worldIn);
    }

    public BossItemEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(SkiesEntityTypes.BOSS_ITEM, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VISIBLE_PLAYER_UNIQUE_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getVisiblePlayerId() != null) {
            compound.m_128362_("VisiblePlayerID", this.getVisiblePlayerId());
        }
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128403_("VisiblePlayerID")) {
            uuid = compound.m_128342_("VisiblePlayerID");
        } else {
            String s = compound.m_128461_("VisiblePlayerID");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            this.setVisiblePlayerId(uuid);
        }
    }

    public UUID getVisiblePlayerId() {
        return ((Optional)this.f_19804_.m_135370_(VISIBLE_PLAYER_UNIQUE_ID)).orElse(null);
    }

    public void setVisiblePlayerId(@Nullable UUID ownerId) {
        this.f_19804_.m_135381_(VISIBLE_PLAYER_UNIQUE_ID, Optional.ofNullable(ownerId));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6123_(Player entityIn) {
        if (this.getVisiblePlayerId() != null && !this.getVisiblePlayerId().equals(entityIn.m_142081_())) {
            return;
        }
        super.m_6123_(entityIn);
    }
}

