/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.block_entity.KeystoneBlockEntity;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import com.legacy.structure_gel.api.structure.processor.RandomBlockSwapProcessor;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;

public class EverbrightBlindingDungeonPieces {
    private static final ResourceLocation base = EverbrightBlindingDungeonPieces.locatePiece("base");
    private static final ResourceLocation segment = EverbrightBlindingDungeonPieces.locatePiece("segment");
    private static final ResourceLocation segmentTop = EverbrightBlindingDungeonPieces.locatePiece("segment_top");
    private static final ResourceLocation towerTop = EverbrightBlindingDungeonPieces.locatePiece("tower_top");
    private static final ResourceLocation bridge = EverbrightBlindingDungeonPieces.locatePiece("bridge");
    private static final ResourceLocation prisonTower = EverbrightBlindingDungeonPieces.locatePiece("small_tower_prison");
    private static final ResourceLocation studyTower = EverbrightBlindingDungeonPieces.locatePiece("small_tower_study");
    private static final ResourceLocation witchTower = EverbrightBlindingDungeonPieces.locatePiece("small_tower_witch");
    private static final List<ResourceLocation> libraryVariants = Lists.newArrayList((Object[])new ResourceLocation[]{EverbrightBlindingDungeonPieces.locatePiece("small_tower_library_1"), EverbrightBlindingDungeonPieces.locatePiece("small_tower_library_2"), EverbrightBlindingDungeonPieces.locatePiece("small_tower_library_3"), EverbrightBlindingDungeonPieces.locatePiece("small_tower_library_4")});

    public static void assemble(StructureManager templateManager, BlockPos pos, Rotation rotation, StructurePiecesBuilder pieces, Random random) {
        int i;
        pieces.m_142679_((StructurePiece)new Piece(templateManager, base, pos, rotation));
        for (i = 1; i <= 4; ++i) {
            pieces.m_142679_((StructurePiece)new Piece(templateManager, segment, pos.m_6630_(8 * i), rotation));
        }
        pieces.m_142679_((StructurePiece)new Piece(templateManager, segmentTop, pos.m_6630_(40), rotation));
        pieces.m_142679_((StructurePiece)new Piece(templateManager, towerTop, pos.m_142082_(-6, 48, -6), rotation));
        i = random.nextInt(3) + 2;
        pieces.m_142679_((StructurePiece)new Piece(templateManager, bridge, pos.m_142082_(6, i * 9 - 2 - i, -5), Rotation.COUNTERCLOCKWISE_90));
        pieces.m_142679_((StructurePiece)new Piece(templateManager, prisonTower, pos.m_142082_(2, i * 9 - 5 - i, -19), Rotation.COUNTERCLOCKWISE_90));
        i = random.nextInt(3) + 2;
        pieces.m_142679_((StructurePiece)new Piece(templateManager, bridge, pos.m_142082_(-6, i * 9 - 2 - i, 7), Rotation.CLOCKWISE_180));
        pieces.m_142679_((StructurePiece)new Piece(templateManager, studyTower, pos.m_142082_(-19, i * 9 - 5 - i, 2), Rotation.CLOCKWISE_180));
        i = random.nextInt(3) + 2;
        pieces.m_142679_((StructurePiece)new Piece(templateManager, bridge, pos.m_142082_(6, i * 9 - 2 - i, 19), Rotation.CLOCKWISE_90));
        pieces.m_142679_((StructurePiece)new Piece(templateManager, witchTower, pos.m_142082_(2, i * 9 - 5 - i, 23), Rotation.CLOCKWISE_90));
        i = random.nextInt(3) + 2;
        pieces.m_142679_((StructurePiece)new Piece(templateManager, bridge, pos.m_142082_(18, i * 9 - 2 - i, 7), Rotation.NONE));
        pieces.m_142679_((StructurePiece)new Piece(templateManager, libraryVariants.get(random.nextInt(libraryVariants.size())), pos.m_142082_(23, i * 9 - 5 - i, 2), Rotation.NONE));
    }

    static ResourceLocation locatePiece(String location) {
        return BlueSkies.locate("dungeons/everbright/blinding/" + location);
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        public Piece(StructureManager structureManager, ResourceLocation name, BlockPos pos, Rotation rotation) {
            super(SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getPieceType(), 0, structureManager, name, Piece.getPlacementSettings(structureManager, name, pos, rotation), pos);
            this.f_73379_ = rotation;
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super(SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getPieceType(), nbt, context.f_192764_(), name -> Piece.getPlacementSettings(context.f_192764_(), name, new BlockPos(nbt.m_128451_("TPX"), nbt.m_128451_("TPY"), nbt.m_128451_("TPZ")), Rotation.valueOf((String)nbt.m_128461_("Rot"))));
        }

        private static StructurePlaceSettings getPlacementSettings(StructureManager structureManager, ResourceLocation name, BlockPos pos, Rotation rotation) {
            Vec3i sizePos = ((StructureTemplate)structureManager.m_163774_(name).get()).m_163801_();
            BlockPos centerPos = new BlockPos(sizePos.m_123341_() / 2, 0, sizePos.m_123343_() / 2);
            StructurePlaceSettings placementSettings = new StructurePlaceSettings().m_163782_(false).m_74379_(rotation).m_74377_(Mirror.NONE).m_74385_(centerPos);
            placementSettings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
            placementSettings.m_74383_((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            placementSettings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.blinding_stone, 0.1f, SkiesBlocks.glowing_blinding_stone));
            return placementSettings;
        }

        public void m_183269_(WorldGenLevel worldIn, StructureFeatureManager structureManager, ChunkGenerator chunkGeneratorIn, Random randomIn, BoundingBox bounds, ChunkPos chunkPosIn, BlockPos pos) {
            super.m_183269_(worldIn, structureManager, chunkGeneratorIn, randomIn, bounds, chunkPosIn, pos);
            if (this.f_163658_.equals(base.toString())) {
                for (int x = 0; x < this.f_73656_.m_163801_().m_123341_(); ++x) {
                    for (int z = 0; z < this.f_73656_.m_163801_().m_123343_(); ++z) {
                        if (this.m_73398_((BlockGetter)worldIn, x, 0, z, bounds).m_60767_() == Material.f_76296_) continue;
                        if (this.m_73398_((BlockGetter)worldIn, x, 0, z, bounds).m_60734_() == SkiesBlocks.bluebright_log) {
                            this.m_73528_(worldIn, SkiesBlocks.bluebright_log.m_49966_(), x, -1, z, bounds);
                            continue;
                        }
                        this.m_73528_(worldIn, SkiesBlocks.turquoise_stonebrick.m_49966_(), x, -1, z, bounds);
                    }
                }
            }
        }

        protected void m_7756_(String key, BlockPos pos, ServerLevelAccessor level, Random rand, BoundingBox sbb) {
            String[] data;
            if ("keystone".equals(key)) {
                level.m_7731_(pos, SkiesBlocks.bright_blinding_keystone.m_49966_(), 3);
                BlockEntity tileEntity = level.m_7702_(pos);
                if (tileEntity instanceof KeystoneBlockEntity.BrightBlindingKeystoneBlockEntity) {
                    ((KeystoneBlockEntity.BrightBlindingKeystoneBlockEntity)tileEntity).setTeleportOffset(new BlockPos(0, 7, 5));
                    ((KeystoneBlockEntity.BrightBlindingKeystoneBlockEntity)tileEntity).setSpawnOffset(new BlockPos(0, 7, 0));
                }
            } else if ("villager".equals(key)) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                Villager entity = (Villager)EntityType.f_20492_.m_20615_((Level)level.m_6018_());
                entity.m_141967_(entity.m_7141_().m_35567_(VillagerType.m_204073_((Holder)level.m_204166_(entity.m_142538_()))));
                entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                level.m_7967_((Entity)entity);
            } else if ("vindicator".equals(key)) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                Vindicator entity = (Vindicator)EntityType.f_20493_.m_20615_((Level)level.m_6018_());
                entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                entity.m_21530_();
                ItemStack axe = new ItemStack((ItemLike)SkiesItems.aquite_axe, 1);
                ToolUtils.setStickType(axe, SkiesItems.bluebright_stick);
                entity.m_8061_(EquipmentSlot.MAINHAND, axe);
                level.m_7967_((Entity)entity);
            } else if ("witch".equals(key)) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                Witch entity = (Witch)EntityType.f_20495_.m_20615_((Level)level.m_6018_());
                entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                entity.m_21530_();
                level.m_7967_((Entity)entity);
            } else if ("cat".equals(key)) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                Cat entity = (Cat)EntityType.f_20553_.m_20615_((Level)level.m_6018_());
                entity.m_6034_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() - 1), (double)pos.m_123343_() + 0.5);
                entity.m_21530_();
                entity.m_7105_(true);
                entity.m_28179_(rand.nextInt(10));
                entity.m_28131_(DyeColor.values()[rand.nextInt(DyeColor.values().length)]);
                entity.m_21816_(UUID.fromString("f2914dae-441a-4254-aa5c-2ec4d917b7a6"));
                entity.m_21837_(true);
                level.m_7967_((Entity)entity);
            } else if ("armor_stand".equals(key)) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                ArmorStand entity = (ArmorStand)EntityType.f_20529_.m_20615_((Level)level.m_6018_());
                entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                entity.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(0.0, 0.0, 0.0));
                entity.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)SkiesItems.pyrope_chestplate));
                level.m_7967_((Entity)entity);
            } else if (key.startsWith("chest") && (data = key.split("-")).length > 1) {
                ResourceLocation loot = SkiesLootProv.BLINDING_LOOT.getOrDefault(data[1], SkiesLootProv.BLINDING_LIBRARY_KEY);
                RandomizableContainerBlockEntity.m_59620_((BlockGetter)level, (Random)rand, (BlockPos)pos.m_7495_(), (ResourceLocation)loot);
            }
        }
    }
}

