/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.network.IMessage;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class VanillaParticleMessage
implements IMessage {
    private static final float WIDTH = 0.8f;
    private static final float CITIZEN_HEIGHT = 2.0f;
    private double x;
    private double y;
    private double z;
    private SimpleParticleType type;

    public VanillaParticleMessage() {
    }

    public VanillaParticleMessage(double x, double y, double z, SimpleParticleType type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    private void spawnParticles(SimpleParticleType particleType, Level world, double x, double y, double z) {
        Random rand = new Random();
        for (int i = 0; i < 5; ++i) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42500_)), x + (double)(rand.nextFloat() * 0.8f * 2.0f) - (double)0.8f, y + 1.0 + (double)(rand.nextFloat() * 2.0f), z + (double)(rand.nextFloat() * 0.8f * 2.0f) - (double)0.8f, d0, d1, d2);
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.m_130085_(this.type.getRegistryName());
    }

    @Override
    public IMessage read(FriendlyByteBuf buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.type = (SimpleParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buffer.m_130281_());
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        if (contextSupplier.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            BrutalBosses.LOGGER.error("Boss capability message sent to the wrong side!", (Throwable)new Exception());
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        this.spawnParticles(this.type, (Level)world, this.x, this.y, this.z);
    }
}

