/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.config;

import cofh.core.CoFHCore;
import cofh.core.config.IBaseConfig;
import cofh.lib.enchantment.EnchantmentCoFH;
import cofh.lib.util.Constants;
import java.util.function.Supplier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.ForgeConfigSpec;

public class CoreEnchantConfig
implements IBaseConfig {
    public static Supplier<Boolean> improvedFeatherFalling = Constants.TRUE;
    public static Supplier<Boolean> improvedMending = Constants.TRUE;
    private Supplier<Boolean> enableHolding;
    private Supplier<Boolean> treasureHolding;
    private Supplier<Integer> levelHolding;

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        String treasure = "This sets whether or not the Enchantment is considered a 'treasure' enchantment.";
        String level = "This option adjusts the maximum allowable level for the Enchantment.";
        builder.push("Enchantments");
        improvedFeatherFalling = builder.comment("If TRUE, Feather Falling will prevent Farmland from being trampled. This option will work with alternative versions (overrides) of Feather Falling.").define("Improved Feather Falling", improvedFeatherFalling);
        improvedMending = builder.comment("If TRUE, Mending behavior is altered so that Experience Orbs always repair items if possible, and the most damaged item is prioritized. This option may not work with alternative versions (overrides) of Mending.").define("Improved Mending", improvedMending);
        builder.push("Holding");
        this.enableHolding = builder.comment("If TRUE, the Holding Enchantment is available for various Storage Items and Blocks.").define("Enable", true);
        this.treasureHolding = builder.comment(treasure).define("Treasure", false);
        this.levelHolding = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.pop();
    }

    @Override
    public void refresh() {
        Enchantment enchantment = CoFHCore.ENCHANTMENTS.get("holding");
        if (enchantment instanceof EnchantmentCoFH) {
            EnchantmentCoFH enc = (EnchantmentCoFH)enchantment;
            enc.setEnable(this.enableHolding.get());
            enc.setTreasureEnchantment(this.treasureHolding.get());
            enc.setMaxLevel(this.levelHolding.get());
        }
    }
}

