/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.config;

import cofh.core.config.IBaseConfig;
import cofh.lib.util.Constants;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class CoreServerConfig
implements IBaseConfig {
    public static Supplier<Boolean> enableFishingExhaustion = Constants.FALSE;
    public static Supplier<Double> amountFishingExhaustion = () -> 0.125;
    public static Supplier<Boolean> enableSaplingGrowthMod = Constants.FALSE;
    public static Supplier<Integer> amountSaplingGrowthMod = () -> 4;

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Gameplay");
        builder.push("Fishing");
        enableFishingExhaustion = builder.comment("If TRUE, Fishing will cause exhaustion.").define("Fishing Exhaustion", enableFishingExhaustion);
        amountFishingExhaustion = builder.comment("This option sets the amount of exhaustion caused by fishing, if enabled.").defineInRange("Fishing Exhaustion Amount", amountFishingExhaustion, 0.0, 10.0);
        builder.pop();
        builder.push("World");
        enableSaplingGrowthMod = builder.comment("If TRUE, Sapling growth will be slowed by a configurable factor.").define("Sapling Growth Reduction", enableSaplingGrowthMod);
        amountSaplingGrowthMod = builder.comment("This option sets the growth factor for saplings - they will only grow 1 in N times.").defineInRange("Sapling Growth Reduction Factor", amountSaplingGrowthMod, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.pop();
    }
}

