/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.filter;

import cofh.core.util.filter.IFilter;
import cofh.core.util.filter.IFilterOptions;
import cofh.core.util.helpers.FluidHelper;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;

public class BaseFluidFilter
implements IFilter,
IFilterOptions {
    public static final int SIZE = 15;
    protected List<FluidStack> fluids;
    protected Predicate<FluidStack> rules;
    protected boolean allowList = false;
    protected boolean checkNBT = false;

    public BaseFluidFilter(int size) {
        this.fluids = new ArrayList<FluidStack>(size);
        for (int i = 0; i < size; ++i) {
            this.fluids.add(FluidStack.EMPTY);
        }
    }

    public int size() {
        return this.fluids.size();
    }

    public List<FluidStack> getFluids() {
        return this.fluids;
    }

    public void setFluids(List<FluidStack> fluids) {
        this.fluids = fluids;
        this.reset();
    }

    public void reset() {
        this.rules = null;
    }

    @Override
    public Predicate<FluidStack> getFluidRules() {
        if (this.rules == null) {
            ObjectOpenHashSet fluidSet = new ObjectOpenHashSet();
            for (FluidStack fluid : this.fluids) {
                fluidSet.add(fluid.getFluid());
            }
            this.rules = arg_0 -> this.lambda$getFluidRules$0((Set)fluidSet, arg_0);
        }
        return this.rules;
    }

    @Override
    public IFilter read(CompoundTag nbt) {
        CompoundTag subTag = nbt.m_128469_("Filter");
        ListTag list = subTag.m_128437_("TankInv", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tankTag = list.m_128728_(i);
            byte tank = tankTag.m_128445_("Tank");
            if (tank < 0 || tank >= this.fluids.size()) continue;
            this.fluids.set(tank, FluidStack.loadFluidStackFromNBT((CompoundTag)tankTag));
        }
        this.allowList = subTag.m_128471_("AllowList");
        this.checkNBT = subTag.m_128471_("CheckNBT");
        return this;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        CompoundTag subTag = new CompoundTag();
        ListTag list = new ListTag();
        for (int i = 0; i < this.fluids.size(); ++i) {
            if (this.fluids.get(i).isEmpty()) continue;
            CompoundTag tankTag = new CompoundTag();
            tankTag.m_128344_("Tank", (byte)i);
            this.fluids.get(i).writeToNBT(tankTag);
            list.add((Object)tankTag);
        }
        subTag.m_128365_("TankInv", (Tag)list);
        subTag.m_128379_("AllowList", this.allowList);
        subTag.m_128379_("CheckNBT", this.checkNBT);
        nbt.m_128365_("Filter", (Tag)subTag);
        return nbt;
    }

    @Override
    public boolean getAllowList() {
        return this.allowList;
    }

    @Override
    public boolean setAllowList(boolean allowList) {
        this.allowList = allowList;
        return true;
    }

    @Override
    public boolean getCheckNBT() {
        return this.checkNBT;
    }

    @Override
    public boolean setCheckNBT(boolean checkNBT) {
        this.checkNBT = checkNBT;
        return true;
    }

    private /* synthetic */ boolean lambda$getFluidRules$0(Set fluidSet, FluidStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (this.checkNBT) {
            for (FluidStack fluid : this.fluids) {
                if (!FluidHelper.fluidsEqualWithTags(stack, fluid)) continue;
                return this.allowList;
            }
            return !this.allowList;
        }
        return this.allowList == fluidSet.contains(stack.getFluid());
    }
}

