/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.network.packet;

import cofh.lib.network.packet.IPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public interface IPacketClient
extends IPacket {
    public void handleClient();

    default public void sendToClients() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        PlayerList list = server.m_6846_();
        list.m_11268_(this.toVanillaPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    default public void sendToPlayer(ServerPlayer player) {
        player.f_8906_.m_141995_(this.toVanillaPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    default public void sendToOps() {
        Packet<?> packet = null;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        PlayerList playerList = server.m_6846_();
        for (ServerPlayer player : playerList.m_11314_()) {
            if (!playerList.m_11303_(player.m_36316_())) continue;
            if (packet == null) {
                packet = this.toVanillaPacket(NetworkDirection.PLAY_TO_CLIENT);
            }
            player.f_8906_.m_141995_(packet);
        }
    }

    default public void sendToAllAround(BlockPos pos, double range, ResourceKey<Level> dim) {
        this.sendToAllAround(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), range, dim);
    }

    default public void sendToAllAround(Vec3 pos, double range, ResourceKey<Level> dim) {
        this.sendToAllAround(pos.f_82479_, pos.f_82480_, pos.f_82481_, range, dim);
    }

    default public void sendToAllAround(double x, double y, double z, double range, ResourceKey<Level> dim) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        PlayerList list = server.m_6846_();
        list.m_11241_(null, x, y, z, range, dim, this.toVanillaPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    default public void sendToChunk(BlockEntity tile) {
        this.sendToChunk((ServerLevel)tile.m_58904_(), tile.m_58899_());
    }

    default public void sendToChunk(ServerLevel world, BlockPos pos) {
        this.sendToChunk(world, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    default public void sendToChunk(ServerLevel world, int chunkX, int chunkZ) {
        this.sendToChunk(world, new ChunkPos(chunkX, chunkZ));
    }

    default public void sendToChunk(ServerLevel world, ChunkPos pos) {
        Packet<?> packet = this.toVanillaPacket(NetworkDirection.PLAY_TO_CLIENT);
        world.m_7726_().f_8325_.m_183262_(pos, false).forEach(e -> e.f_8906_.m_141995_(packet));
    }
}

